/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: zmat2cart.c,v 1.1.1.1 2001/01/15 07:43:49 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

#define aabs(x)  ((x>=0.0)?(x):(-x))

static int z2c(int n, int c1, float ra, int c2, float an, 
    int c3, float tw, float* xx, float* yy, float* zz);
static int chkcolinear(int n, int c1, int c2, int c3);

int zmat2cart(int natom)
{
  int ck;
  int n;
  float xx,yy,zz;

  for (n=1; n<natom; n++) {
    /*  n  ele  c1  radii  c2  angle  c3  twist  */
    if(n != atom[n].AtomOrder) {
      /*printf("Illigal atom order: %d, %d\n", n, atom[n].AtomOrder);*/
      exit(2);
    } else if (n>=MAXATOM) {
      /*printf("Too many atoms \n");*/
      exit(4);
    }

    ck=z2c(n, atom[n].nAtom1, atom[n].nLength, 
	atom[n].nAtom2, atom[n].nAngle, atom[n].nAtom3, atom[n].nTwist, 
	&xx, &yy, &zz);
    if (ck==0) return(0);
    atom[n].x=xx; atom[n].y=yy; atom[n].z=zz;
/*printf("%d %2s %f %f %f \n", n, atom[n].Name, atom[n].x, atom[n].y, atom[n].z);*/
  }

  return(1);

}

int z2c(int n, int c1, float ra, int c2, float an, 
    int c3, float tw, float* xx, float* yy, float* zz)
{
  int i1, i2, i3, i4;
  float x1, y1, z1, x2, y2, z2, x3, y3, z3; 
  float nr1n, nr12, nr23, v1n[3], v12[3], v23[3];
  float nr1n_new, new_v1n[3];
  float cosA, sinA, cosB, sinB, cosC, sinC, Ra[3][3], Rb[3][3], Rc[3][3];
  float ip_v12v23;
  float xl, yl, zl, xm, ym, zm;
  float cosP, sinP, xp, yp, zp, xq, yq, zq;
  float l1, l4, l7, l3, l6, l9;

/*printf(">>%d : %d %f %d %f %d %f \n", n, c1, ra, c2, an, c3, tw); */

  x1=atom[c1].x; y1=atom[c1].y; z1=atom[c1].z;
  x2=atom[c2].x; y2=atom[c2].y; z2=atom[c2].z;
  x3=atom[c3].x; y3=atom[c3].y; z3=atom[c3].z;
  if (n==1) {
    *xx=0.0; *yy=0.0; *zz=0.0;
  } else if (n==2) {
    *xx=0.0; *yy=0.0; *zz=ra;
  } else if (n==3) {
    *xx=ra*aabs(sin(an*PI/180.0)); *yy=0.0; 
    *zz=z1+((z2>z1)?(1):(-1))*ra*cos(an*PI/180.0);
  } else {
    /* if atoms c1, c2, c3 are colinear then ERROR ! */
    if (chkcolinear(n, c1, c2, c3)==0)
      return(0); 

/*printf("(1)%d:%f,%f,%f; (2)%d:%f,%f,%f; (3)%d:%f,%f,%f\n", 
c1, x1, y1, z1,  c2, x2, y2, z2,  c3, x3, y3, z3);*/
    nr1n=ra; /* norm of v1n[] */
    v1n[0]=ra*sin(PI*an/180)*cos(PI*tw/180); /* vector v1n[] */
    v1n[1]=ra*sin(PI*an/180)*sin(PI*tw/180);
    v1n[2]=ra*cos(PI*an/180);
/*printf("v(1n)%f: %f %f %f::\n",nr1n,v1n[0],v1n[1],v1n[2]);*/
    v12[0]=(x2-x1); v12[1]=(y2-y1); v12[2]=(z2-z1);    /* vector v12[] */
    nr12=sqrt(v12[0]*v12[0]+v12[1]*v12[1]+v12[2]*v12[2]);  /* norm of v12[] */
/*printf("v(12)%f: %f %f %f::\n",nr12,v12[0],v12[1],v12[2]);*/
    v23[0]=(x3-x2); v23[1]=(y3-y2); v23[2]=(z3-z2);    /* vector v23[] */
    nr23=sqrt(v23[0]*v23[0]+v23[1]*v23[1]+v23[2]*v23[2]);  /* norm of v23[] */
/*printf("(23)%f: %f %f %f::\n",nr23,v23[0],v23[1],v23[2]);*/
    ip_v12v23=v12[0]*v23[0]+v12[1]*v23[1]+v12[2]*v23[2]; /* scaler product v12.v23 */
    cosP=(ip_v12v23)/(nr12*nr23); sinP=sqrt(1-cosP*cosP);
    /**/
    xl=x2-x1; yl=y2-y1; zl=z2-z1; /* mol coordinate */
    xm=x3-x1; ym=y3-y1; zm=z3-z1;
    xp=0; yp=0; zp=nr12; /* local coordinate */
    xq=sinP*nr23; yq=0; zq=zp+cosP*nr23;
    /**/
    l3=xl/zp; /* sinBcosA */
    l6=yl/zp; /* sinBsinA */
    l9=zl/zp; /* cosB */
    l1=(xm-l3*zq)/xq; /* cosCcosBcosA-sinCsinA */
    l4=(ym-l6*zq)/xq; /* cosCcosBsinA+sinCcosA */
    l7=(zm-l9*zq)/xq; /* -cosCsinB */
/*printf("(147) %f %f %f, (369) %f %f %f\n", l1,l4,l7, l3,l6,l9);*/
    /** Eulerian angles **/
    cosB=l9; sinB=sqrt(1-cosB*cosB);
    if (sinB!=0) {
      cosA=l3/sinB; sinA=l6/sinB;
      cosC=-l7/sinB; 
      if (cosA!=0) sinC=(l4-cosC*cosB*sinA)/cosA;
      else         sinC=-l1*sinA;
    } else {
      cosC=1; sinC=0;
      cosA=l1*cosB; sinA=l4*cosB;
    }
    /* rotation around z by angle A */
/*printf("A: %f, %f \n", cosA, sinA);*/
    Ra[0][0]=cosA;  Ra[0][1]=sinA;  Ra[0][2]=0;
    Ra[1][0]=-sinA; Ra[1][1]=cosA;  Ra[1][2]=0;
    Ra[2][0]=0;     Ra[2][1]=0;     Ra[2][2]=1;
    /* rotation around y by angle B */
/*printf("B: %f, %f \n", cosB, sinB);*/
    Rb[0][0]=cosB;  Rb[0][1]=0;  Rb[0][2]=-sinB;
    Rb[1][0]=0;     Rb[1][1]=1;  Rb[1][2]=0;
    Rb[2][0]=sinB; Rb[2][1]=0;  Rb[2][2]=cosB;
    /* rotation around z' by angle C */
/*printf("C: %f, %f \n", cosC, sinC);*/
    Rc[0][0]=cosC;  Rc[0][1]=sinC;  Rc[0][2]=0; 
    Rc[1][0]=-sinC; Rc[1][1]=cosC;  Rc[1][2]=0;
    Rc[2][0]=0;     Rc[2][1]=0;     Rc[2][2]=1;
    /* new_v1n[]=~Ra[][].~Rb[][].~Rc[][].v1n[] */
    for(i1=0; i1<3; i1++) {
      new_v1n[i1]=0;
      for(i2=0; i2<3; i2++)
	for(i3=0; i3<3; i3++)
	  for(i4=0; i4<3; i4++)
	    new_v1n[i1]+=Ra[i2][i1]*Rb[i3][i2]*Rc[i4][i3]*v1n[i4];
    }
    nr1n_new=sqrt(new_v1n[0]*new_v1n[0]+new_v1n[1]*new_v1n[1]+new_v1n[2]*new_v1n[2]);  /* norm of new_v1n[] */
/*printf("new_v(1n)%f: %f %f %f::\n",nr1n_new,new_v1n[0],new_v1n[1],new_v1n[2]);*/

    /* optained coordinate is X(1)+dX(n) */
    *xx=x1+new_v1n[0];
    *yy=y1+new_v1n[1];
    *zz=z1+new_v1n[2];
  }
  return(1);
}

int chkcolinear(int n, int c1, int c2, int c3)
{
  float r1, r2, cos_th;
  float v1[3], v2[3];
  float x1, y1, z1, x2, y2, z2, x3, y3, z3; 
  char s[BUFFLEN];

/*printf("Atoms %d: %d %d %d \n", n, c1, c2, c3);*/

  x1=atom[c1].x; y1=atom[c1].y; z1=atom[c1].z;
  x2=atom[c2].x; y2=atom[c2].y; z2=atom[c2].z;
  x3=atom[c3].x; y3=atom[c3].y; z3=atom[c3].z;

  v1[0]=x1-x3;
  v1[1]=y1-y3;
  v1[2]=z1-z3;
  v2[0]=x2-x3;
  v2[1]=y2-y3;
  v2[2]=z2-z3;

  r1=sqrt(v1[0]*v1[0]+v1[1]*v1[1]+v1[2]*v1[2]);
  r2=sqrt(v2[0]*v2[0]+v2[1]*v2[1]+v2[2]*v2[2]);

  cos_th=(v1[0]*v2[0]+v1[1]*v2[1]+v1[2]*v2[2])/(r1*r2);

/*printf("%f %f: %f;\n", r1, r2, cos_th); */

  if (fabs(fabs(cos_th)-1.0)<=1e-6) {
    sprintf(s, "%d: atoms %d %d %d are colinear !\n", n, c1, c2, c3);
    Caution(toplevel, s);
    return(0);
  } else {
    return(1);
  }

}
