/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: zmat.c,v 1.1.1.1 2001/01/15 07:43:49 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void zcloseCB(Widget w, XtPointer clientData, XtPointer callData)
{
  XtUnmanageChild(zmatW);
}
/*%%%%%%%%%%%%%%%%%%%%*/
void znewatomCB(Widget w, XtPointer clientData, XtPointer callData)
{
  XtManageChild(atom[Natom].AtomID); 
  Natom++;
}
/*%%%%%%%%%%%%%%%%%%%%*/
void zinsertCB(Widget w, XtPointer clientData, XtPointer callData)
{
  int i;

  XtManageChild(atom[Natom].AtomID); 

  for (i=Natom; i>focusedAtomOrder; i--) {
    switch (i) {
    default:
      atom[i].nAtom3=atom[i-1].nAtom3;
      if (atom[i].nAtom3>=focusedAtomOrder && atom[i].nAtom3>0) atom[i].nAtom3++;
      strcpy(atom[i].cTwist, atom[i-1].cTwist);
      sprintf(atom[i].cAtom3, "%d", atom[i].nAtom3);
      XmTextFieldSetString(atom[i].Atom3ID, atom[i].cAtom3);
      EnterAtomX(atom[i].Atom3ID, &atom[i], NULL);
      XmTextFieldSetString(atom[i].TwistID, atom[i].cTwist);
      EnterZValue(atom[i].TwistID, &atom[i], NULL);
    case 4:
      atom[i].nAtom2=atom[i-1].nAtom2;
      if (atom[i].nAtom2>=focusedAtomOrder && atom[i].nAtom2>0) atom[i].nAtom2++;
      strcpy(atom[i].cAngle, atom[i-1].cAngle);
      sprintf(atom[i].cAtom2, "%d", atom[i].nAtom2);
      XmTextFieldSetString(atom[i].Atom2ID, atom[i].cAtom2);
      EnterAtomX(atom[i].Atom2ID, &atom[i], NULL);
      XmTextFieldSetString(atom[i].AngleID, atom[i].cAngle);
      EnterZValue(atom[i].AngleID, &atom[i], NULL);
    case 3:
      atom[i].nAtom1=atom[i-1].nAtom1;
      if (atom[i].nAtom1>=focusedAtomOrder && atom[i].nAtom1>0) atom[i].nAtom1++;
      strcpy(atom[i].cLength, atom[i-1].cLength);
      sprintf(atom[i].cAtom1, "%d", atom[i].nAtom1);
      XmTextFieldSetString(atom[i].Atom1ID, atom[i].cAtom1);
      EnterAtomX(atom[i].Atom1ID, &atom[i], NULL);
      XmTextFieldSetString(atom[i].LengthID, atom[i].cLength);
      EnterZValue(atom[i].LengthID, &atom[i], NULL);
    case 2:
      strcpy(atom[i].Name, atom[i-1].Name);
      XmTextFieldSetString(atom[i].NameID, atom[i].Name);
      EnterAtomName(atom[i].NameID, &atom[i], NULL);
    case 1:
      ;
    }
  }
  switch (focusedAtomOrder) {
  default:
    atom[focusedAtomOrder].nAtom3=-1;
    strcpy(atom[focusedAtomOrder].cTwist, " ");
    sprintf(atom[focusedAtomOrder].cAtom3, "%d", atom[focusedAtomOrder].nAtom3);
    XmTextFieldSetString(atom[focusedAtomOrder].Atom3ID, atom[focusedAtomOrder].cAtom3);
    EnterAtomX(atom[focusedAtomOrder].Atom3ID, &atom[focusedAtomOrder], NULL);
    XmTextFieldSetString(atom[focusedAtomOrder].TwistID, atom[focusedAtomOrder].cTwist);
    EnterZValue(atom[focusedAtomOrder].TwistID, &atom[focusedAtomOrder], NULL);
  case 3:
    atom[focusedAtomOrder].nAtom2=-1;
    strcpy(atom[focusedAtomOrder].cAngle, " ");
    sprintf(atom[focusedAtomOrder].cAtom2, "%d", atom[focusedAtomOrder].nAtom2);
    XmTextFieldSetString(atom[focusedAtomOrder].Atom2ID, atom[focusedAtomOrder].cAtom2);
    EnterAtomX(atom[focusedAtomOrder].Atom2ID, &atom[focusedAtomOrder], NULL);
    XmTextFieldSetString(atom[focusedAtomOrder].AngleID, atom[focusedAtomOrder].cAngle);
    EnterZValue(atom[focusedAtomOrder].AngleID, &atom[focusedAtomOrder], NULL);
  case 2:
    atom[focusedAtomOrder].nAtom1=-1;
    strcpy(atom[focusedAtomOrder].cLength, " ");
    sprintf(atom[focusedAtomOrder].cAtom1, "%d", atom[focusedAtomOrder].nAtom1);
    XmTextFieldSetString(atom[focusedAtomOrder].Atom1ID, atom[focusedAtomOrder].cAtom1);
    EnterAtomX(atom[focusedAtomOrder].Atom1ID, &atom[focusedAtomOrder], NULL);
    XmTextFieldSetString(atom[focusedAtomOrder].LengthID, atom[focusedAtomOrder].cLength);
    EnterZValue(atom[focusedAtomOrder].LengthID, &atom[focusedAtomOrder], NULL);
  case 1:
    strcpy(atom[focusedAtomOrder].Name, " ");
    XmTextFieldSetString(atom[focusedAtomOrder].NameID, atom[focusedAtomOrder].Name);
    EnterAtomName(atom[focusedAtomOrder].NameID, &atom[focusedAtomOrder], NULL);
  }
  switch (focusedAtomOrder) {
  case 1:
    atom[2].nAtom1=-1;
    strcpy(atom[2].cLength, " ");
    sprintf(atom[2].cAtom1, "%d", atom[2].nAtom1);
    XmTextFieldSetString(atom[2].Atom1ID, atom[2].cAtom1);
    EnterAtomX(atom[2].Atom1ID, &atom[2], NULL);
    XmTextFieldSetString(atom[2].LengthID, atom[2].cLength);
    EnterZValue(atom[2].LengthID, &atom[2], NULL);
  case 2:
    atom[3].nAtom2=-1;
    strcpy(atom[3].cAngle, " ");
    sprintf(atom[3].cAtom2, "%d", atom[3].nAtom2);
    XmTextFieldSetString(atom[3].Atom2ID, atom[3].cAtom2);
    EnterAtomX(atom[3].Atom2ID, &atom[3], NULL);
    XmTextFieldSetString(atom[3].AngleID, atom[3].cAngle);
    EnterZValue(atom[3].AngleID, &atom[3], NULL);
  case 3:
    atom[4].nAtom3=-1;
    strcpy(atom[4].cTwist, " ");
    sprintf(atom[4].cAtom3, "%d", atom[4].nAtom3);
    XmTextFieldSetString(atom[4].Atom3ID, atom[4].cAtom3);
    EnterAtomX(atom[4].Atom3ID, &atom[4], NULL);
    XmTextFieldSetString(atom[4].TwistID, atom[4].cTwist);
    EnterZValue(atom[4].TwistID, &atom[4], NULL);
  default:
    ;
  }
  Natom++;
}
/*%%%%%%%%%%%%%%%%%%%%*/
void zcutCB(Widget w, XtPointer clientData, XtPointer callData)
{
  int i;

  cutBufferAtom=atom[focusedAtomOrder];

  for (i=focusedAtomOrder; i<Natom-1; i++) {
    switch (i) {
    default:
      atom[i].nAtom3=atom[i+1].nAtom3;
      if (atom[i].nAtom3>focusedAtomOrder && atom[i].nAtom3>0) atom[i].nAtom3--;
      else if (atom[i].nAtom3==focusedAtomOrder && atom[i].nAtom3>0) atom[i].nAtom3=-1;
      strcpy(atom[i].cTwist, atom[i+1].cTwist);
      sprintf(atom[i].cAtom3, "%d", atom[i].nAtom3);
      XmTextFieldSetString(atom[i].Atom3ID, atom[i].cAtom3);
      EnterAtomX(atom[i].Atom3ID, &atom[i], NULL);
      XmTextFieldSetString(atom[i].TwistID, atom[i].cTwist);
      EnterZValue(atom[i].TwistID, &atom[i], NULL);
    case 3:
      atom[i].nAtom2=atom[i+1].nAtom2;
      if (atom[i].nAtom2>focusedAtomOrder && atom[i].nAtom2>0) atom[i].nAtom2--;
      else if (atom[i].nAtom2==focusedAtomOrder && atom[i].nAtom2>0) atom[i].nAtom2=-1;
      strcpy(atom[i].cAngle, atom[i+1].cAngle);
      sprintf(atom[i].cAtom2, "%d", atom[i].nAtom2);
      XmTextFieldSetString(atom[i].Atom2ID, atom[i].cAtom2);
      EnterAtomX(atom[i].Atom2ID, &atom[i], NULL);
      XmTextFieldSetString(atom[i].AngleID, atom[i].cAngle);
      EnterZValue(atom[i].AngleID, &atom[i], NULL);
    case 2:
      atom[i].nAtom1=atom[i+1].nAtom1;
      if (atom[i].nAtom1>focusedAtomOrder && atom[i].nAtom1>0) atom[i].nAtom1--;
      else if (atom[i].nAtom1==focusedAtomOrder && atom[i].nAtom1>0) atom[i].nAtom1=-1;
      strcpy(atom[i].cLength, atom[i+1].cLength);
      sprintf(atom[i].cAtom1, "%d", atom[i].nAtom1);
      XmTextFieldSetString(atom[i].Atom1ID, atom[i].cAtom1);
      EnterAtomX(atom[i].Atom1ID, &atom[i], NULL);
      XmTextFieldSetString(atom[i].LengthID, atom[i].cLength);
      EnterZValue(atom[i].LengthID, &atom[i], NULL);
    case 1:
      strcpy(atom[i].Name, atom[i+1].Name);
      XmTextFieldSetString(atom[i].NameID, atom[i].Name);
      EnterAtomName(atom[i].NameID, &atom[i], NULL);
    }
  }

  zDelLastAtomCB(w, clientData, callData);
}
/*%%%%%%%%%%%%%%%%%%%%*/
void zcopyCB(Widget w, XtPointer clientData, XtPointer callData)
{
  cutBufferAtom=atom[focusedAtomOrder];
}
/*%%%%%%%%%%%%%%%%%%%%*/
void zpasteCB(Widget w, XtPointer clientData, XtPointer callData)
{
  zinsertCB(w, clientData, callData);

  switch (focusedAtomOrder) {
  default:
    atom[focusedAtomOrder].nAtom3=-1;
    strcpy(atom[focusedAtomOrder].cTwist, cutBufferAtom.cTwist);
    sprintf(atom[focusedAtomOrder].cAtom3, "%d", atom[focusedAtomOrder].nAtom3);
    XmTextFieldSetString(atom[focusedAtomOrder].Atom3ID, atom[focusedAtomOrder].cAtom3);
    EnterAtomX(atom[focusedAtomOrder].Atom3ID, &atom[focusedAtomOrder], NULL);
    XmTextFieldSetString(atom[focusedAtomOrder].TwistID, atom[focusedAtomOrder].cTwist);
    EnterZValue(atom[focusedAtomOrder].TwistID, &atom[focusedAtomOrder], NULL);
  case 3:
    atom[focusedAtomOrder].nAtom2=-1;
    strcpy(atom[focusedAtomOrder].cAngle, cutBufferAtom.cAngle);
    sprintf(atom[focusedAtomOrder].cAtom2, "%d", atom[focusedAtomOrder].nAtom2);
    XmTextFieldSetString(atom[focusedAtomOrder].Atom2ID, atom[focusedAtomOrder].cAtom2);
    EnterAtomX(atom[focusedAtomOrder].Atom2ID, &atom[focusedAtomOrder], NULL);
    XmTextFieldSetString(atom[focusedAtomOrder].AngleID, atom[focusedAtomOrder].cAngle);
    EnterZValue(atom[focusedAtomOrder].AngleID, &atom[focusedAtomOrder], NULL);
  case 2:
    atom[focusedAtomOrder].nAtom1=-1;
    strcpy(atom[focusedAtomOrder].cLength, cutBufferAtom.cLength);
    sprintf(atom[focusedAtomOrder].cAtom1, "%d", atom[focusedAtomOrder].nAtom1);
    XmTextFieldSetString(atom[focusedAtomOrder].Atom1ID, atom[focusedAtomOrder].cAtom1);
    EnterAtomX(atom[focusedAtomOrder].Atom1ID, &atom[focusedAtomOrder], NULL);
    XmTextFieldSetString(atom[focusedAtomOrder].LengthID, atom[focusedAtomOrder].cLength);
    EnterZValue(atom[focusedAtomOrder].LengthID, &atom[focusedAtomOrder], NULL);
  case 1:
    strcpy(atom[focusedAtomOrder].Name, cutBufferAtom.Name);
    XmTextFieldSetString(atom[focusedAtomOrder].NameID, atom[focusedAtomOrder].Name);
    EnterAtomName(atom[focusedAtomOrder].NameID, &atom[focusedAtomOrder], NULL);
  }
}
/*%%%%%%%%%%%%%%%%%%%%*/
void zDelLastAtomCB(Widget w, XtPointer clientData, XtPointer callData)
{
  if (Natom<=1) return;
  Natom--;

  delAtom(Natom);
}
/*%%%%%%%%%%%%%%%%%%%%*/
void zClrAllAtomsCB(Widget w, XtPointer clientData, XtPointer callData)
{
  delAllAtoms();
  CannotDraw=TRUE;
}
/*%%%%%%%%%%%%%%%%%%%%*/
void zapplyCB(Widget w, XtPointer clientData, XtPointer callData)
{
  if (CheckLabelDefinition(zmatW) && CheckBlankForm(zmatW) 
      && CheckAtoms(zmatW) && (zmat2cart(Natom)!=0)) {
    firstRot(Natom);
    CannotDraw=FALSE;
  } else {
    CannotDraw=TRUE;
  }
}
/*%%%%%%%%%%%%%%%%%%%%*/
void zpackCB(Widget w, XtPointer clientData, XtPointer callData)
{
  int i;

  for(i=Natom-1; i>=1; i--) {
    if (isBlankLine(atom[i].Name)) {
      focusedAtomOrder=i;
      zcutCB(w, clientData, callData);
    }
  }
}
/*%%%%%%%%%%%%%%%%%%%%*/
void zsendCB(Widget w, XtPointer clientData, XtPointer callData)
{
  int j, match=0, labelNo=0;
  char *zlabel;

  if (focusedAtomWidget==atom[focusedAtomOrder].LengthID && atom[focusedAtomOrder].UseLabelLength) {
      zlabel=atom[focusedAtomOrder].cLength;
  } else if (focusedAtomWidget==atom[focusedAtomOrder].AngleID && atom[focusedAtomOrder].UseLabelAngle) {
      zlabel=atom[focusedAtomOrder].cAngle;
  } else if (focusedAtomWidget==atom[focusedAtomOrder].TwistID && atom[focusedAtomOrder].UseLabelTwist) {
      zlabel=atom[focusedAtomOrder].cTwist;
  } else {
    return;
  }

/*printf("focusedLabel=%s\n", zlabel);*/

  j=1;
  while(j<Nlabel && (match=strcmp(zlabel, label[j].Tag))!=0
	&& (*(zlabel)!='-' || (match=strcmp((zlabel+1), label[j].Tag))!=0)) {
	j++;
  }
  labelNo=j;
  if (match==0 && *(zlabel)!='-') {
    /*printf("label match: %s(%d)\n", zlabel, labelNo);*/;
  } else if (match==0 && *(zlabel)=='-') {
    /*printf("label match: %s(%d)\n", zlabel, labelNo);*/;
  } else if (match!=0) {
    /*printf("label: %s(%d): not defined\n", zlabel, labelNo);*/
    if (labelNo==Nlabel) {
      lnewlabelCB(w, NULL, NULL);
      sscanf(zlabel, "%s", label[labelNo].Tag);
      XmTextFieldSetString(label[labelNo].TagID, label[labelNo].Tag);
      EnterTag(label[labelNo].TagID, &label[labelNo], NULL);
    }
  }

  /*printf("%d->",focusedLabelNo );*/
  while (focusedLabelNo!=labelNo) {
    kbTravNextTGCB(label[focusedLabelNo].TagID, &label[focusedLabelNo], NULL);
    focusedLabelNo++;
    if (focusedLabelNo==Nlabel) focusedLabelNo=1;
  }
  /*printf("%d\n",focusedLabelNo );*/
  kbTravNextCB(label[focusedLabelNo].TagID, &label[focusedLabelNo], NULL);
  lobscuredCB(w, NULL, NULL);
}
/*%%%%%%%%%%%%%%%%%%%%*/
