/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: view.c,v 1.1.1.1 2001/01/15 07:43:49 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void viewCB(Widget w, XtPointer clientData, XtPointer callData)
{
  XSetWindowAttributes viewwinattr;

  /* check atom-data */
  if (CheckLabelDefinition(viewW) && CheckBlankForm(viewW) 
      && CheckAtoms(viewW) && (zmat2cart(Natom)!=0)) {
    firstRot(Natom);
    CannotDraw=FALSE; 
  } else {
    CannotDraw=TRUE; 
  }
  /********************/
  XtManageChild(viewW);
  /********************/
  /**/
  viewwinattr.backing_store = Always;
  viewwinattr.save_under = True;
  XChangeWindowAttributes(XtDisplay(viewwindrawarea), XtWindow(viewwindrawarea), CWBackingStore, &viewwinattr);
}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
void vcloseCB(Widget w, XtPointer clientData, XtPointer callData)
{
  XtUnmanageChild(viewW);
}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
void axesCB(Widget w, XtPointer p, XtPointer callData)
{
  if ((int)p==SHOW) {
    if (!showAxes) showAxes=TRUE;
  } else if  ((int)p==HIDE) {
    if (showAxes) showAxes=FALSE;
  }
}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
void gridCB(Widget w, XtPointer p, XtPointer callData)
{
  if ((int)p==SHOW) {
    if (!showGrid) showGrid=TRUE;
  } else if  ((int)p==HIDE) {
    if (showGrid) showGrid=FALSE;
  }
}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
void numberingCB(Widget w, XtPointer p, XtPointer callData)
{
  if ((int)p==SHOW) {
    if (!showNumbering) showNumbering=TRUE;
  } else if  ((int)p==HIDE) {
    if (showNumbering) showNumbering=FALSE;
  }
}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
/*  call from ScrollBar or DrawingArea ? 
  check callback reason : callData.reason */
void drawCB(Widget w, XtPointer clientData, XtPointer callData)
{
XmScrollBarCallbackStruct *bar_p;
XmDrawingAreaCallbackStruct *da_p;

bar_p=(XmScrollBarCallbackStruct *)callData;
da_p=(XmDrawingAreaCallbackStruct *)callData;
/*printf("reason:_%i_%i_\n", bar_p->reason, da_p->reason);*/

if (da_p->reason == XmCR_EXPOSE || da_p->reason == XmCR_RESIZE ) {
  redrawCB(w, clientData, callData);
} else if (bar_p->reason == XmCR_VALUE_CHANGED) {
  redrawCB(w, clientData, callData);
}

}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
Boolean drawMolTimeOut(Widget w)
{
  static XtIntervalId id=0;

  if (id!=0) XtRemoveTimeOut(id);
  id=XtAppAddTimeOut(app, 30, (XtTimerCallbackProc)drawMol, w);
  /*drawMol(w);*/

  return TRUE;
}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
void redrawCB(Widget w, XtPointer clientData, XtPointer callData)
{
  if (CheckLabelDefinition(viewW) && CheckBlankForm(viewW) 
      && CheckAtoms(viewW) && zmat2cart(Natom)!=0) {
    firstRot(Natom);
    CannotDraw=FALSE;
    XtAppAddWorkProc(app, (XtWorkProc)drawMolTimeOut, w);
  }
}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
void zoomCB(Widget w, XtPointer clientData, XmScaleCallbackStruct *callData)
{
  factor=callData->value;
  if (factor==0) factor=1;
  factor=100/factor;
}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
void resetviewCB(Widget w, XtPointer clientData, XtPointer callData)
{
  Arg args[10];

  RR[0][0]=1;  RR[0][1]=0;  RR[0][2]=0; 
  RR[1][0]=0;  RR[1][1]=1;  RR[1][2]=0; 
  RR[2][0]=0;  RR[2][1]=0;  RR[2][2]=1; 

  factor=1;
  XmScaleSetValue(viewwinzoomSC, 100);

  viewwinhbar=viewwinvbar=0;
  hbar_prev=vbar_prev=0;
  XtSetArg(args[0], XmNvalue, 0);
  XtSetValues(viewwinhscrollbar, args, 1);
  XtSetValues(viewwinvscrollbar, args, 1);
}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
void trackBallOnOffEH(Widget w, XtPointer clientData, XKeyEvent *event)
{

  if (clientData==(XtPointer)KEYPRESS) {
    /*printf("KeyPress\n");*/
    isTrackBallOn=TRUE;
    redrawCB(w, clientData, NULL);
    XtAddEventHandler(viewwindrawarea, ButtonPressMask | Button1MotionMask, FALSE, (XtEventHandler)trackBallEH, NULL);
    XtAddEventHandler(viewwindrawarea, ButtonPressMask | Button1MotionMask, FALSE, (XtEventHandler)redrawCB, NULL);
  } else if (clientData==(XtPointer)KEYRELEASE) {
    /*printf("KeyRelease\n");*/
    isTrackBallOn=FALSE;
    redrawCB(w, clientData, NULL);
    XtRemoveEventHandler(viewwindrawarea, ButtonPressMask | Button1MotionMask, FALSE, (XtEventHandler)trackBallEH, NULL);
    XtRemoveEventHandler(viewwindrawarea, ButtonPressMask | Button1MotionMask, FALSE, (XtEventHandler)redrawCB, NULL);
  } else printf("Hi !\n");
}
/*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*//*%%%%%%%%%%%%%%%%%%%%*/
void trackBallEH(Widget w, XtPointer clientData, XMotionEvent *event)
{
  static float x0, y0;
  float delX=0, delY=0, x1, y1, delZ;
  int i1, i2, i3;
  float sin_s, cos_s, sin_t, cos_t, S[3][3];
  Arg args[10];


  /*printf("%d", event->state);*/
  if ((event->state)&1) {
    /*printf(" ShiftKey\n");*/
    switch (event->type) {
    case ButtonPress:
      x0=event->x; y0=event->y; break;
    case MotionNotify:
      x1=event->x; y1=event->y;
      delX=+(x1-x0)*0.5; delY=-(y1-y0)*0.5;
      /*printf("motion:%g,%g\n", delX, delY);*/
      /* Scroll Bar */
      hbar_prev+=delX*1; 
      if (hbar_prev>180) hbar_prev=-180; 
      else if (hbar_prev<-180) hbar_prev=180; 
      vbar_prev-=delY*1;
      if (vbar_prev>180) vbar_prev=-180; 
      else if (vbar_prev<-180) vbar_prev=180; 
      XtSetArg(args[0], XmNvalue, hbar_prev);
      XtSetValues(viewwinhscrollbar, args, 1);
      XtSetArg(args[0], XmNvalue, vbar_prev);
      XtSetValues(viewwinvscrollbar, args, 1);
      /* Rotation matrix */
      sin_s=sin(PI*delX/180); cos_s=cos(PI*delX/180);
      sin_t=sin(PI*delY/180); cos_t=cos(PI*delY/180);
      R[0][0]=cos_s;        R[0][1]=0;      R[0][2]=sin_s;
      R[1][0]=-sin_s*sin_t; R[1][1]=cos_t;  R[1][2]=cos_s*sin_t;
      R[2][0]=-sin_s*cos_t; R[2][1]=-sin_t; R[2][2]=cos_s*cos_t;
      /* S[][]=R[][]*RR[][] */
      for(i1=0; i1<3; i1++)
	for(i2=0; i2<3; i2++) {
	  S[i1][i2]=0;
	  for(i3=0; i3<3; i3++)
	    S[i1][i2]+=R[i1][i3]*RR[i3][i2];
	}
      /* New RR[][] */
      for(i1=0; i1<3; i1++)
	for(i2=0; i2<3; i2++)
	  RR[i1][i2]=S[i1][i2];
      /* rotate atoms */
      moreRot(Natom);
      /**/
      x0=x1; y0=y1; break;
    }

  } else if ((event->state)&2) {
    /*printf(" CapsLockKey\n");*/
    isTrackBallOn=FALSE;
    redrawCB(w, clientData, NULL);
  } else if ((event->state)&4) {
    /*printf(" CtrlKey\n");*/
    isTrackBallOn=FALSE;
    redrawCB(w, clientData, NULL);
  } else if ((event->state)&8) {
    /*printf(" AltKey+(%d)\n", event->type);*/
    switch (event->type) {
    case ButtonPress:
    case MotionNotify:
      /* Rotation matrix */
      delZ=1.0;
      sin_s=sin(PI*delZ/180); cos_s=cos(PI*delZ/180);
      R[0][0]=cos_s;   R[0][1]=-sin_s; R[0][2]=0;
      R[1][0]=sin_s;   R[1][1]=cos_s;  R[1][2]=0;
      R[2][0]=0;       R[2][1]=0;      R[2][2]=1;
      /* S[][]=R[][]*RR[][] */
      for(i1=0; i1<3; i1++)
	for(i2=0; i2<3; i2++) {
	  S[i1][i2]=0;
	  for(i3=0; i3<3; i3++)
	    S[i1][i2]+=R[i1][i3]*RR[i3][i2];
	}
      /* New RR[][] */
      for(i1=0; i1<3; i1++)
	for(i2=0; i2<3; i2++)
	  RR[i1][i2]=S[i1][i2];
      /* rotate atoms */
      moreRot(Natom);
    }
  } else {
    /*printf(" Another key\n");*/
    isTrackBallOn=FALSE;
    redrawCB(w, clientData, NULL);
  }
}
