/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: template.c,v 1.1.1.1 2001/01/15 07:43:49 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void zTemplateCB(Widget w, XtPointer clientData, XtPointer callData)
{
  char *groupName, *s, s0[BUFFLEN], s1[BUFFLEN], templateFileName[BUFFLEN];
  FILE *templateFileP;
  int num, i, substPosition;
  char atomName[MAXNAMELANGTH];
  int conn1, conn2, conn3;
  float bondLength, bondAngle, bondTwist;

  groupName=(char *)clientData;
  /*printf("%s\n", groupName);*/

  if ((s=getenv("KUMIDIR"))==NULL) {
    strcpy(templateFileName, "./KUMI.Template");
  } else {
    strcpy(templateFileName, s);
    strcat(templateFileName, "/KUMI.Template");
  }
  /*printf("%s\n", s);*/

  if ((templateFileP=fopen(templateFileName, "r"))==NULL) {
    strcpy(s1, "Template data file: file open error.\n");
    printf("%s", s1);
    exit(11);
  }

  fgets(s0, BUFFLEN, templateFileP);
  /*printf("%s", s0);*/
  while (strstr(s0, groupName)==NULL) {
    if (fgets(s0, BUFFLEN, templateFileP)==NULL) {
      strcpy(s1, "Template data file: file read error or end-of-file.\n");
      exit(12);
    }
    /*printf("%s", s0);*/
  }
  /*printf("%s", s0);*/
  sscanf(s0, "%s%d", s1, &num);

  substPosition=focusedAtomOrder;
  /*printf("%d  %d\n", num, substPosition);*/
  for(i=0; i<num; i++) {
    if (fgets(s0, BUFFLEN, templateFileP)==NULL) {
      strcpy(s1, "Template data file: file read error or end-of-file.\n");
      exit(13);
    }
    sscanf(s0, "%s%d%f%d%f%d%f", atomName, &conn1, &bondLength, &conn2, &bondAngle, &conn3, &bondTwist);
    /*printf(":%s:%d:%f:%d:%f:%d:%f:\n", atomName, conn1, bondLength, conn2, bondAngle, conn3, bondTwist);*/
    if (i==0) {
      /* atom Name */
      strcpy(atom[substPosition].Name, atomName);
      XmTextFieldSetString(atom[substPosition].NameID, atom[substPosition].Name);
      EnterAtomName(atom[substPosition].NameID, &atom[substPosition], NULL);
      if (substPosition!=1) {
	/* bond Length */
	sprintf(s1, "%g", bondLength);
	strcpy(atom[substPosition].cLength, s1);
	XmTextFieldSetString(atom[substPosition].LengthID, atom[substPosition].cLength);
	EnterZValue(atom[substPosition].LengthID, &atom[substPosition], NULL);
      }
      focusedAtomOrder++;
    } else {
      zinsertCB(w, clientData, callData); /*insert*/
      /* atom Name */
      strcpy(atom[focusedAtomOrder].Name, atomName);
      XmTextFieldSetString(atom[focusedAtomOrder].NameID, atom[focusedAtomOrder].Name);
      EnterAtomName(atom[focusedAtomOrder].NameID, &atom[focusedAtomOrder], NULL);
      /* connect Atom1 */
      atom[focusedAtomOrder].nAtom1=conn1+substPosition-1;
      sprintf(atom[focusedAtomOrder].cAtom1, "%d", atom[focusedAtomOrder].nAtom1);
      XmTextFieldSetString(atom[focusedAtomOrder].Atom1ID, atom[focusedAtomOrder].cAtom1);
      EnterAtomX(atom[focusedAtomOrder].Atom1ID, &atom[focusedAtomOrder], NULL);
      /* bond Length */
      sprintf(s1, "%g", bondLength);
      strcpy(atom[focusedAtomOrder].cLength, s1);
      XmTextFieldSetString(atom[focusedAtomOrder].LengthID, atom[focusedAtomOrder].cLength);
      EnterZValue(atom[focusedAtomOrder].LengthID, &atom[focusedAtomOrder], NULL);
      if (focusedAtomOrder<2) continue;
      /* connect Atom2 */
      if (conn2==0) atom[focusedAtomOrder].nAtom2=atom[substPosition].nAtom1;
      else atom[focusedAtomOrder].nAtom2=conn2+substPosition-1;
      sprintf(atom[focusedAtomOrder].cAtom2, "%d", atom[focusedAtomOrder].nAtom2);
      XmTextFieldSetString(atom[focusedAtomOrder].Atom2ID, atom[focusedAtomOrder].cAtom2);
      EnterAtomX(atom[focusedAtomOrder].Atom2ID, &atom[focusedAtomOrder], NULL);
      /* bond angle */
      sprintf(s1, "%g", bondAngle);
      strcpy(atom[focusedAtomOrder].cAngle, s1);
      XmTextFieldSetString(atom[focusedAtomOrder].AngleID, atom[focusedAtomOrder].cAngle);
      EnterZValue(atom[focusedAtomOrder].AngleID, &atom[focusedAtomOrder], NULL);
      if (focusedAtomOrder<3) continue;
      /* connect Atom3 */
      if (conn3==0) atom[focusedAtomOrder].nAtom3=atom[substPosition].nAtom1;
      else if (conn3==-1) atom[focusedAtomOrder].nAtom3=atom[substPosition].nAtom2;
      else atom[focusedAtomOrder].nAtom3=conn3+substPosition-1;
      sprintf(atom[focusedAtomOrder].cAtom3, "%d", atom[focusedAtomOrder].nAtom3);
      XmTextFieldSetString(atom[focusedAtomOrder].Atom3ID, atom[focusedAtomOrder].cAtom3);
      EnterAtomX(atom[focusedAtomOrder].Atom3ID, &atom[focusedAtomOrder], NULL);
      /* bond Twist angle */
      sprintf(s1, "%g", bondTwist);
      strcpy(atom[focusedAtomOrder].cTwist, s1);
      XmTextFieldSetString(atom[focusedAtomOrder].TwistID, atom[focusedAtomOrder].cTwist);
      EnterZValue(atom[focusedAtomOrder].TwistID, &atom[focusedAtomOrder], NULL);
      /**/
      focusedAtomOrder++;
    }
  }

  fclose(templateFileP);
}
