/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: save.c,v 1.1.1.1 2001/01/15 07:43:49 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void dosaveCB(Widget w, XtPointer clientData, XtPointer callData)
{
  char  *s, m[20];
  char buff[BUFFLEN];
  FILE  *fp, *fp2;
  int  i;

  s = XmTextGetString(savefnameF);
  if (isBlankLine(s)) {
    Caution(w, "File OPEN error (1)");
    return;
  } 

  if (saveType[0]) strcpy(m, "Gaussian Z-matrix");
  else if (saveType[1]) strcpy(m, "MOPAC Z-matrix");
  else if (saveType[2]) strcpy(m, "Cartesian"); 
  else strcpy(m, "???"); 

  /*printf("(doSaveCB) File name is :%s: \n Mode : %s \n", s, m);*/

  if (saveType[1] && !(CheckLabelDefinition(viewW) && CheckBlankForm(viewW) 
      && CheckAtoms(viewW) && zmat2cart(Natom)!=0)) {
    Caution(w, "Atoms not ready");
    return;
  }
  if (saveType[2] && !(CheckLabelDefinition(viewW) && CheckBlankForm(viewW) 
      && CheckAtoms(viewW) && zmat2cart(Natom)!=0)) {
    Caution(w, "Atoms not ready");
    return;
  }

  strcpy(FileName, s);

  /* open file */
  if ( (fp=fopen(s, "r"))!=NULL ) {
    fclose(fp);
    XtManageChild(overWriteWin);
    while(XtIsManaged(overWriteWin)) {
      XEvent event;
      XtAppNextEvent(app, &event);
      XtDispatchEvent(&event);
    }
    if (overWriteOk) {
      /*printf("overwrite\n");*/
    } else {
      /*printf("Don't write\n");*/
      Caution(w, "Don't write\n");
      return;
    }
  } else {
    /*printf("New file\n");*/
    /*fclose(fp);*/
  }
  if ((fp=fopen(s, "w"))==NULL) {
    Caution(w, "File OPEN error");
    return;
  } 
  fp2=stdout;
  /* write data */ /* write data */ /* write data */ /* write data */
  if (saveType[0]) { 
    /***** write atomic coordinates as Gaussian Z-matrix form *****/
    /***** write atomic coordinates as Gaussian Z-matrix form *****/
    if (!isBlankLine(Link0)) {
      fprintf(fp, "%s \n", Link0);
      /*fprintf(fp2, "%s \n", Link0);*/
    }
    if (isBlankLine(Headings)) 
      sprintf(Headings, "# Put your keywords such as, `HF/3-21G' \n");
    fprintf(fp, "%s \n", Headings);
    /*fprintf(fp2, "%s \n", Headings);*/
    if (isBlankLine(Comments[0]))
      sprintf(Comments[0], "%s\n", s);
    for (i=0; i<5; i++) {
      if (isBlankLine(Comments[i])) break;
      fprintf(fp, "%s", Comments[i]);
      /*fprintf(fp2, "%s", Comments[i]);*/
    }
    fprintf(fp, "\n%d %d \n", charge, multi);
    /*fprintf(fp2, "\n%d %d \n", charge, multi);*/
    for(i=1; i<Natom; i++) {
      if (i==1) {
	fprintf(fp, "%s \n", atom[i].Name);
	/*fprintf(fp2, "%s \n", atom[i].Name);*/
      } else if (i==2) {
	fprintf(fp, "%s %3d %s \n", atom[i].Name, atom[i].nAtom1, atom[i].cLength);
	/*fprintf(fp2, "%s %3d %s \n", atom[i].Name, atom[i].nAtom1, atom[i].cLength);*/
      } else if (i==3) {
	fprintf(fp, "%s %3d %s %3d %s \n", atom[i].Name, atom[i].nAtom1, atom[i].cLength, atom[i].nAtom2, atom[i].cAngle);
	/*fprintf(fp2, "%s %3d %s %3d %s \n", atom[i].Name, atom[i].nAtom1, atom[i].cLength, atom[i].nAtom2, atom[i].cAngle);*/
      } else {
	fprintf(fp, "%s %3d %s %3d %s %3d %s\n", atom[i].Name, atom[i].nAtom1, atom[i].cLength, atom[i].nAtom2, atom[i].cAngle, atom[i].nAtom3, atom[i].cTwist);
	/*fprintf(fp2, "%s %3d %s %3d %s %3d %s\n", atom[i].Name, atom[i].nAtom1, atom[i].cLength, atom[i].nAtom2, atom[i].cAngle, atom[i].nAtom3, atom[i].cTwist);*/
      }
    }
    fprintf(fp, " \n");
    /*fprintf(fp2, " \n");*/
    for(i=1; i<Nlabel; i++){
      if (isBlankLine(label[i].Tag)==FALSE) {
	fprintf(fp, "%s %f\n", label[i].Tag, label[i].nValue);
	/*fprintf(fp2, "%s %g\n", label[i].Tag, label[i].nValue);*/
      }
    }
  } else if (saveType[1]) { 
    /***** write atomic coordinates as MOPAC Z-matrix form *****/
    /***** write atomic coordinates as MOPAC Z-matrix form *****/
    if (isBlankLine(Headings)) 
      if (isBlankLine(Link0))
	sprintf(Headings, "# Put your keywords such as, `PM3' \n");
      else
	sprintf(Headings, "%s", Link0);
    if (isBlankLine(Comments[0]))
      sprintf(Comments[0], "%s : some comments\n", s);
    if (isBlankLine(Comments[1]))
      sprintf(Comments[1], "other comments here\n");
    fprintf(fp, "%s%s%s", Headings, Comments[0], Comments[1]);
    /*fprintf(fp2, "%s%s%s", Headings, Comments[0], Comments[1]);*/
    for(i=1; i<Natom; i++) {
      if (i==1) {
	fprintf(fp, "%s \n", atom[i].Name);
	/*fprintf(fp2, "%s \n", atom[i].Name);*/
      } else if (i==2) {
	fprintf(fp, "%s %g 1 \n", atom[i].Name, atom[i].nLength);
	/*fprintf(fp2, "%s %g 1 \n", atom[i].Name, atom[i].nLength);*/
      } else if (i==3) {
	fprintf(fp, "%s %g 1 %g 1 0.0 1   %3d %3d   0\n", atom[i].Name, atom[i].nLength, atom[i].nAngle, atom[i].nAtom1, atom[i].nAtom2);
	/*fprintf(fp2, "%s %g 1 %g 1 0.0 1   %3d %3d   0\n", atom[i].Name, atom[i].nLength, atom[i].nAngle, atom[i].nAtom1, atom[i].nAtom2);*/

      } else {
	fprintf(fp, "%s %g 1 %g 1 %g 1   %3d %3d %3d \n", atom[i].Name, atom[i].nLength, atom[i].nAngle, atom[i].nTwist, atom[i].nAtom1, atom[i].nAtom2, atom[i].nAtom3);
	/*fprintf(fp2, "%s %g 1 %g 1 %g 1   %3d %3d %3d \n", atom[i].Name, atom[i].nLength, atom[i].nAngle, atom[i].nTwist, atom[i].nAtom1, atom[i].nAtom2, atom[i].nAtom3);*/
      }
    }
    fprintf(fp, " \n");
    /*fprintf(fp2, " \n");*/
  } else if (saveType[2]) { 
    /***** write atomic coordinates as Cartesian form *****/
    /***** write atomic coordinates as Cartesian form *****/
    fprintf(fp, "%d \n%s \n", Natom-1, s);
    /*fprintf(fp2, "%d \n%s \n", Natom-1, s);*/
    for(i=1; i<Natom; i++) {
      fprintf(fp, "%s %f %f %f \n", atom[i].Name, atom[i].x, atom[i].y, atom[i].z);
      /*fprintf(fp2, "%s %f %f %f \n", atom[i].Name, atom[i].x, atom[i].y, atom[i].z);*/
    }
  }
  fprintf(fp, " \n");
  /*fprintf(fp2, " \n");*/
  /* close file */
  fclose(fp);

  sprintf(buff, "Save Data: OK\n type: %s\n filename: %s\n", m, s);
  Caution(toplevel, buff);
}
