/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: rotate.c,v 1.1.1.1 2001/01/15 07:43:49 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void barCB(Widget bar, XtPointer p, XmScrollBarCallbackStruct *cdata)
{
  int  which, i1, i2, i3;
  Arg  args[20];
  long  v, del_h, del_v;
  float  sin_t, cos_t, S[3][3];

  which=(int)p;
  XtSetArg(args[0], XmNvalue, &v); XtGetValues(bar, args, 1);
  if (which == HBAR)        viewwinhbar=v;
  else if (which == VBAR)   viewwinvbar=v;

  /* rotated angle */
  del_h=viewwinhbar-hbar_prev; del_v=-(viewwinvbar-vbar_prev);
/*printf(" hbar: %ld , vbar: %ld, del_hbar: %ld , del_vbar: %ld\n", hbar, vbar, del_h, del_v);*/

  /* Rotation matrix */
  if (which == HBAR) {
    sin_t=sin(PI*del_h/180); cos_t=cos(PI*del_h/180);
    R[0][0]=cos_t;  R[0][1]=0;   R[0][2]=sin_t;
    R[1][0]=0;      R[1][1]=1;   R[1][2]=0;
    R[2][0]=-sin_t; R[2][1]=0;   R[2][2]=cos_t;
  }  else if (which == VBAR) {
    sin_t=sin(PI*del_v/180); cos_t=cos(PI*del_v/180);
    R[0][0]=1;     R[0][1]=0;     R[0][2]=0;
    R[1][0]=0;     R[1][1]=cos_t; R[1][2]=sin_t;
    R[2][0]=0;     R[2][1]=-sin_t; R[2][2]=cos_t;
  }
  /* S[][]=R[][]*RR[][] */
  for(i1=0; i1<3; i1++)
    for(i2=0; i2<3; i2++) {
      S[i1][i2]=0;
      for(i3=0; i3<3; i3++)
	S[i1][i2]+=R[i1][i3]*RR[i3][i2];
    }
  /* New RR[][] */
  for(i1=0; i1<3; i1++)
    for(i2=0; i2<3; i2++)
      RR[i1][i2]=S[i1][i2];
  /* rotate atoms */
  moreRot(Natom);

  if (cdata->reason == XmCR_VALUE_CHANGED) {
    XtSetArg(args[0], XmNvalue, &v); XtGetValues(bar, args, 1);
    if (v == 181) {
      XtSetArg(args[0], XmNvalue, -180); XtSetValues(bar, args, 1);
    } else if (v == -181) {
      XtSetArg(args[0], XmNvalue, 180); XtSetValues(bar, args, 1);
    }
  }

  hbar_prev=viewwinhbar; vbar_prev=viewwinvbar;

}
/*%%%%%%%%%%%%%%%%%%%%*/
void firstRot(int natom)
{
  int i1, i2, n;
  float  x[3], xnew[3], dd;

  for(n=1; n<natom; n++) {
    x[0]=atom[n].x; x[1]=atom[n].y; x[2]=atom[n].z;

    /*  xnew[]=RR[][]*x[] */
    for(i1=0; i1<3; i1++) {
      xnew[i1]=0;
      for(i2=0; i2<3; i2++)
	xnew[i1]+=RR[i1][i2]*x[i2];
    }

    atom[n].x2=xnew[0]; atom[n].y2=xnew[1]; atom[n].z2=xnew[2];

    dd=sqrt(x[0]*x[0]+x[1]*x[1]+x[2]*x[2]);
    /*printf("firstRot:dd=%g\n", dd);*/
    region=(region>dd)?region:dd;
  }
  if (region<1e-6) region=1.0;
}
/*%%%%%%%%%%%%%%%%%%%%*/
void moreRot(int natom)
{
  int i1, i2, n;
  float  x[3], xnew[3];

  for(n=1; n<natom; n++) {
    x[0]=atom[n].x2; x[1]=atom[n].y2; x[2]=atom[n].z2;

    /*  xnew[]=R[][]*x[] */
    for(i1=0; i1<3; i1++) {
      xnew[i1]=0;
      for(i2=0; i2<3; i2++)
	xnew[i1]+=R[i1][i2]*x[i2];
    }

    atom[n].x2=xnew[0]; atom[n].y2=xnew[1]; atom[n].z2=xnew[2];
/*printf("%d:(x2,y2,z2)=(%g,%g,%g)\n", n,atom[n].x2,atom[n].y2,atom[n].z2);*/
  }
}
