/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: load.c,v 1.1.1.1 2001/01/15 07:43:49 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void doloadCB(Widget w, XtPointer clientData, XtPointer callData)
{
  char  *s, buf[BUFFLEN], buf2[BUFFLEN];
  FILE  *fp;
  int  i;

  s = XmTextGetString(loadfnameF);
  if (isBlankLine(s)) {
    Caution(w, "File OPEN error (1)\n\nBlank File Name");
    return;
  } 

  /*printf("(doLoadCB) File name is :%s:\n", s);*/
  strcpy(FileName, s);

  /* open file */
  if ((fp=fopen(s, "r"))==NULL) {
    Caution(w, "File OPEN error (2)\n\nFile cannot be opend");
    return;
  } 
  /* clear stored data */
  delAllAtoms();
  delAllLabels();
  /* clear headings and comments */
  strcpy(Link0, "");
  strcpy(Headings, "");
  for(i=0;i<5;i++) strcpy(Comments[i], "");
  /* Read Data */  /* Read Data */  /* Read Data */
  /* ONLY Gaussian type Z-matrix form can be read */
  /* ONLY Gaussian type Z-matrix form can be read */

  /* Link 0 Commands and Route section */
  fgets(buf, BUFFLEN, fp); /*puts(buf);*/
  chopLeadingSpace(buf, buf2);
  strcpy(buf, buf2); /*puts(buf);*/
  if (buf[0]!='%' && buf[0]!='#') goto fileTypeERROR;
  if (buf[0]=='%') { /* Link 0 section */
    while(buf[0]=='%') {
      strcat(Link0, buf);
      fgets(buf, BUFFLEN, fp); /*puts(buf);*/
      chopLeadingSpace(buf, buf2);
      strcpy(buf, buf2); /*puts(buf);*/
    }
  }
  if (buf[0]!='#') goto haveNotRouteSectionERROR;
  while (!isBlankLine(buf)) { /* Route section */
    strcat(Headings, buf);
    fgets(buf, BUFFLEN, fp); /*puts(buf);*/
    chopLeadingSpace(buf, buf2);
    strcpy(buf, buf2); /*puts(buf);*/
  }
  if (isBlankLine(buf)==FALSE) goto fileTypeERROR; /* blank line */
  /* Job Title Section */
  for (i=0; i<MAXTITLE; i++) {
    fgets(buf, BUFFLEN, fp); /*puts(buf);*/ /* Comment */
    if (isBlankLine(buf)) break;
    else strcpy(Comments[i], buf);
  }
  /* ignore more than MAXTITLE(==5) line of comments */
  if (i == MAXTITLE) {
    while(!isBlankLine(buf)) fgets(buf, BUFFLEN, fp);
  }

  /* Charge and Spin-multiplicity */
  fgets(buf, BUFFLEN, fp); /*puts(buf);*/ /* charge & multi */
  if (sscanf(buf, "%d%d", &charge, &multi)==EOF) goto fileTypeERROR;

  /* Molecular section: Z-matrix */
  i=1;
  fgets(buf, BUFFLEN, fp); /*puts(buf);*/
  strChar2Spc(buf, ',');
  while(!isBlankLine(buf)) {
    if (i==1) {
      sscanf(buf, "%s", atom[i].Name);
    } else if (i==2) {
      sscanf(buf, "%s%d%s", atom[i].Name, &atom[i].nAtom1, atom[i].cLength);
    } else if (i==3) {
      sscanf(buf, "%s%d%s%d%s", atom[i].Name, &atom[i].nAtom1, atom[i].cLength, &atom[i].nAtom2, atom[i].cAngle);
    } else {
      sscanf(buf, "%s%d%s%d%s%d%s", atom[i].Name, &atom[i].nAtom1, atom[i].cLength, &atom[i].nAtom2, atom[i].cAngle, &atom[i].nAtom3, atom[i].cTwist);
    }
    switch (i) {
    default:
      sprintf(atom[i].cAtom3, "%d", atom[i].nAtom3);
      XmTextFieldSetString(atom[i].Atom3ID, atom[i].cAtom3);
      EnterAtomX(atom[i].Atom3ID, &atom[i], NULL);
      XmTextFieldSetString(atom[i].TwistID, atom[i].cTwist);
      EnterZValue(atom[i].TwistID, &atom[i], NULL);
    case 3:
      sprintf(atom[i].cAtom2, "%d", atom[i].nAtom2);
      XmTextFieldSetString(atom[i].Atom2ID, atom[i].cAtom2);
      EnterAtomX(atom[i].Atom2ID, &atom[i], NULL);
      XmTextFieldSetString(atom[i].AngleID, atom[i].cAngle);
      EnterZValue(atom[i].AngleID, &atom[i], NULL);
    case 2:
      sprintf(atom[i].cAtom1, "%d", atom[i].nAtom1);
      XmTextFieldSetString(atom[i].Atom1ID, atom[i].cAtom1);
      EnterAtomX(atom[i].Atom1ID, &atom[i], NULL);
      XmTextFieldSetString(atom[i].LengthID, atom[i].cLength);
      EnterZValue(atom[i].LengthID, &atom[i], NULL);
    case 1:
      XmTextFieldSetString(atom[i].NameID, atom[i].Name);
      EnterAtomName(atom[i].NameID, &atom[i], NULL);
    }

    fgets(buf, BUFFLEN, fp); /*puts(buf);*/
    strChar2Spc(buf, ',');
    i++;
  }
  Natom=i;
  /* molecular section: Labels */
  i=1;
  fgets(buf, BUFFLEN, fp); /*puts(buf);*/
  strChar2Spc(buf, ',');
  strChar2Spc(buf, '=');
  while(isBlankLine(buf)==FALSE) {
    sscanf(buf, "%s%f", label[i].Tag, &label[i].nValue);

    XmTextFieldSetString(label[i].TagID, label[i].Tag);
    EnterTag(label[i].TagID, &label[i], NULL);

    sprintf(label[i].cValue, "%g", label[i].nValue);
    XmTextFieldSetString(label[i].ValueID, label[i].cValue);
    EnterValue(label[i].ValueID, &label[i], NULL);

    fgets(buf, BUFFLEN, fp); /*puts(buf);*/
    strChar2Spc(buf, ',');
    strChar2Spc(buf, '=');
    i++;
  }
  Nlabel=i;
  /* close file */
  fclose(fp);
  /* re-XtManage z-mat win & label-edit win */
  for(i=1; i<Natom; i++) {
    XtManageChild(atom[i].AtomID);
  }
  for(i=1; i<Nlabel; i++) {
    XtManageChild(label[i].LabelrcID);
  }
  if (XtIsManaged(viewW)) redrawCB(w, NULL, NULL);

  Caution(w, "Load Data: OK");
  return;

 fileTypeERROR:
  Caution(w, "File type ERROR\n\nExpecting Gaussian-type input file");
  return;
 haveNotRouteSectionERROR:
  Caution(w, "File type ERROR\n\nThere is no Route section");
  return;
}
/*%%%%%%%%%%%%%%%%%%%%*/
