/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: label.c,v 1.1.1.1 2001/01/15 07:43:49 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void lnewlabelCB(Widget w, XtPointer clientData, XtPointer callData)
{
  XtManageChild(label[Nlabel].LabelrcID); 
  Nlabel++;
}
/*%%%%%%%%%%%%%%%%%%%%*/
void linsertCB(Widget w, XtPointer clientData, XtPointer callData)
{
  int i;

  XtManageChild(label[Nlabel].LabelrcID); 

  for (i=Nlabel; i>focusedLabelNo; i--) {
    strcpy(label[i].Tag, label[i-1].Tag);
    label[i].nValue=label[i-1].nValue;

    XmTextFieldSetString(label[i].TagID, label[i].Tag);
    EnterTag(label[i].TagID, &label[i], NULL);

    sprintf(label[i].cValue, "%g", label[i].nValue);
    XmTextFieldSetString(label[i].ValueID, label[i].cValue);
    EnterValue(label[i].ValueID, &label[i], NULL);
  }

  strcpy(label[focusedLabelNo].Tag, "");
  label[focusedLabelNo].nValue=0;

  XmTextFieldSetString(label[focusedLabelNo].TagID, label[focusedLabelNo].Tag);
  EnterTag(label[focusedLabelNo].TagID, &label[focusedLabelNo], NULL);

  strcpy(label[focusedLabelNo].cValue, "");
  XmTextFieldSetString(label[focusedLabelNo].ValueID, label[focusedLabelNo].cValue);
  EnterValue(label[focusedLabelNo].ValueID, &label[focusedLabelNo], NULL);

  Nlabel++;
}
/*%%%%%%%%%%%%%%%%%%%%*/
void lcutCB(Widget w, XtPointer clientData, XtPointer callData)
{
  int i;

  cutBufferLabel=label[focusedLabelNo];

  for(i=focusedLabelNo; i<Nlabel-1; i++) {
    strcpy(label[i].Tag, label[i+1].Tag);
    label[i].nValue=label[i+1].nValue;

    XmTextFieldSetString(label[i].TagID, label[i].Tag);
    EnterTag(label[i].TagID, &label[i], NULL);

    sprintf(label[i].cValue, "%g", label[i].nValue);
    XmTextFieldSetString(label[i].ValueID, label[i].cValue);
    EnterValue(label[i].ValueID, &label[i], NULL);
  }

  lDelLastLabelCB(w, clientData, callData);
}
/*%%%%%%%%%%%%%%%%%%%%*/
void lcopyCB(Widget w, XtPointer clientData, XtPointer callData)
{
  cutBufferLabel=label[focusedLabelNo];

/*printf("%s=%s:%g\n", cutBufferLabel.Tag, cutBufferLabel.cValue, cutBufferLabel.nValue);*/
}
/*%%%%%%%%%%%%%%%%%%%%*/
void lpasteCB(Widget w, XtPointer clientData, XtPointer callData)
{
  linsertCB(w, clientData, callData);

  strcpy(label[focusedLabelNo].Tag, cutBufferLabel.Tag);
  label[focusedLabelNo].nValue=cutBufferLabel.nValue;

    XmTextFieldSetString(label[focusedLabelNo].TagID, label[focusedLabelNo].Tag);
    EnterTag(label[focusedLabelNo].TagID, &label[focusedLabelNo], NULL);

    sprintf(label[focusedLabelNo].cValue, "%g", label[focusedLabelNo].nValue);
    XmTextFieldSetString(label[focusedLabelNo].ValueID, label[focusedLabelNo].cValue);
    EnterValue(label[focusedLabelNo].ValueID, &label[focusedLabelNo], NULL);
}
/*%%%%%%%%%%%%%%%%%%%%*/
void lpackCB(Widget w, XtPointer clientData, XtPointer callData)
{
  int i;

  for(i=Nlabel-1; i>=1; i--) {
    if (isBlankLine(label[i].Tag)) {
      focusedLabelNo=i;
      lcutCB(w, clientData, callData);
    }
  }
}
/*%%%%%%%%%%%%%%%%%%%%*/
/* delete last item */
void lDelLastLabelCB(Widget w, XtPointer clientData, XtPointer callData)
{
  if (Nlabel<=1) return;
  Nlabel--;

  delLabel(Nlabel);
}
/*%%%%%%%%%%%%%%%%%%%%*/
void lClrAllLabelsCB(Widget w, XtPointer clientData, XtPointer callData)
{
  delAllLabels();
}
/*%%%%%%%%%%%%%%%%%%%%*/
void lcloseCB(Widget w, XtPointer clientData, XtPointer callData)
{
  XtUnmanageChild(labeleditW);
}
/*%%%%%%%%%%%%%%%%%%%%*/
void lapplyCB(Widget w, XtPointer clientData, XtPointer callData)
{
  CheckLabelDefinition(w);
  lpackCB(w, clientData, callData);
}
