/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: kumi02.h,v 1.1.1.1 2001/01/15 07:43:49 rmiya Exp $ 
 **
 ********************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <X11/Xlib.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/DrawingA.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>

#define VISIBLE_COUNT 20
#define MAXATOM  100
#define MAXNAMELANGTH 20
#define MAXLABELLENGTH 20
#define MAXLABEL  100
#define MAXTITLE 5 /* Maximum Number of title line of Gaussian 94 Input File */
#define PI 3.14159265358979L
#define BUFFLEN 512

#define SHOW  1
#define HIDE  2
/*#define DAWIDTH  500*/ /* width of molecular drawing area on your display in pixel unit */
#define HBAR  1
#define VBAR  2
#define GRID  10 /* width of XY-plane */
#define AXIS  20 /* length of XYZ-axes */
#define VIEWPOS 70 /* The observer is staying at (0,0,VIEWPOS) and looking to the origin */
#define SCDIST 50 /* The screen distance from the observer (plane Z=20) */
#define KEYPRESS  1
#define KEYRELEASE  2
#define NsaveType  3

void initWorkareas(void);
void initMain(void);
void initElementData(void);
void quitCB(Widget w, XtPointer clientData, XtPointer callData);
void closeWinCB(Widget w, Widget subWin, XtPointer callData);
void pushCB(Widget w, XtPointer clientData, XtPointer callData);

void initAbout(void);
void aboutCB(Widget w, XtPointer clientData, XtPointer callData);
void initHelp(void);
void helpCB(Widget w, XtPointer clientData, XtPointer callData);
void initCaution(void);
void Caution(Widget w, char *s);

void initLabelEditWin(void);
void initLabelWidget(void);
void labeleditCB(Widget w, XtPointer clientData, XtPointer callData);
void lcloseCB(Widget w, XtPointer clientData, XtPointer callData);
void lapplyCB(Widget w, XtPointer clientData, XtPointer callData);
void lnewlabelCB(Widget w, XtPointer clientData, XtPointer callData);
void lfocusCB(Widget w, XtPointer p, XtPointer callData);
void linsertCB(Widget w, XtPointer clientData, XtPointer callData);
void lcutCB(Widget w, XtPointer clientData, XtPointer callData);
void lcopyCB(Widget w, XtPointer clientData, XtPointer callData);
void lpasteCB(Widget w, XtPointer clientData, XtPointer callData);
void lpackCB(Widget w, XtPointer clientData, XtPointer callData);
void lDelLastLabelCB(Widget w, XtPointer clientData, XtPointer callData);
void lClrAllLabelsCB(Widget w, XtPointer clientData, XtPointer callData);
void lLastCB(Widget w, XtPointer clientData, XtPointer callData);
void lobscuredCB(Widget w, XtPointer p, XtPointer callData);
void EnterTag(Widget w, XtPointer p, XtPointer calldata);
void EnterValue(Widget w, XtPointer p, XtPointer calldata);
char *str2upper(char *out, char *in);
void delLabel(int n);
void delAllLabels(void);
void kbTravNextCB(Widget w, XtPointer clientData, XtPointer callData);
void kbTravNextTGCB(Widget w, XtPointer clientData, XtPointer callData);

void initZmatEditWin(void);
void initZmatWidget(void);
void zmatCB(Widget w, XtPointer clientData, XtPointer callData);
void zcloseCB(Widget w, XtPointer clientData, XtPointer callData);
void zapplyCB(Widget w, XtPointer clientData, XtPointer callData);
void zfocusCB(Widget w, XtPointer p, XtPointer callData);
void znewatomCB(Widget w, XtPointer clientData, XtPointer callData);
void zinsertCB(Widget w, XtPointer clientData, XtPointer callData);
void zcutCB(Widget w, XtPointer clientData, XtPointer callData);
void zcopyCB(Widget w, XtPointer clientData, XtPointer callData);
void zpasteCB(Widget w, XtPointer clientData, XtPointer callData);
void zDelLastAtomCB(Widget w, XtPointer clientData, XtPointer callData);
void zClrAllAtomsCB(Widget w, XtPointer clientData, XtPointer callData);
void zLastCB(Widget w, XtPointer clientData, XtPointer callData);
void zpackCB(Widget w, XtPointer clientData, XtPointer callData);
void zsendCB(Widget w, XtPointer clientData, XtPointer callData);
void zobscuredCB(Widget w, XtPointer p, XtPointer callData);
void EnterAtomName(Widget w, XtPointer p_name, XtPointer calldata);
void EnterAtomX(Widget w, XtPointer p, XtPointer calldata);
void EnterZValue(Widget w, XtPointer p, XtPointer calldata);
void delAtom(int n);
void delAllAtoms(void);
void zTemplateCB(Widget w, XtPointer s, XtPointer callData);

void initViewWin(void);
void viewCB(Widget w, XtPointer clientData, XtPointer callData);
void vcloseCB(Widget w, XtPointer clientData, XtPointer callData);
void axesCB(Widget w, XtPointer p, XtPointer callData);
void gridCB(Widget w, XtPointer p, XtPointer callData);
void numberingCB(Widget w, XtPointer p, XtPointer callData);
void drawCB(Widget w, XtPointer clientData, XtPointer callData);
void redrawCB(Widget w, XtPointer clientData, XtPointer callData);
void resetviewCB(Widget w, XtPointer clientData, XtPointer callData);
void barCB(Widget bar, XtPointer p, XmScrollBarCallbackStruct *cdata);
void zoomCB(Widget w, XtPointer clientData, XmScaleCallbackStruct *callData);
void trans3dto2d(float xyz[3], float newxyz[3]);
void getDisplayCoordinates(float x[2], float y[2]);
Boolean drawMol(Widget w);
Boolean drawMolTimeOut(Widget w);
void firstRot(int natom);
void moreRot(int natom);
void drawAxes(Widget w);
void drawGrid(Widget w);
void drawNumbering(Widget da, float displayX, float displayY, int AtomOrder);
int CheckLabelDefinition(Widget w);
int CheckAtoms(Widget w);
int CheckBlankForm(Widget w);
int zmat2cart(int natom);

void trackBallOnOffEH(Widget w, XtPointer clientData, XKeyEvent *event);
void trackBallEH(Widget w, XtPointer clientData, XMotionEvent *event);
void drawTrackBall(Widget w);

void initFile(void);
void loadCB(Widget w, XtPointer clientData, XtPointer callData);
void doloadCB(Widget w, XtPointer clientData, XtPointer callData);
void fileselCB(Widget w, Widget saveW, XtPointer callData);
void okCB(Widget w, Widget win, XmFileSelectionBoxCallbackStruct *callData);
void destroyWinCB(Widget w, Widget d, XtPointer callData);
void saveCB(Widget w, XtPointer clientData, XtPointer callData);
void toggleCB(Widget w, XtPointer clientData, XtPointer callData);
void dosaveCB(Widget w, XtPointer clientData, XtPointer callData);
Boolean isBlankLine(char *s);
char *strChar2Spc(char *s, char c);
void overWriteCB(Widget w, XtPointer clientData, XtPointer callData);
void chopLeadingSpace(char *in, char *out);

int DAWIDTH;
XtAppContext  app; 
Widget toplevel;
Widget loadW, saveW, zmatW, labeleditW, viewW, cautionW, aboutW, helpW;
Widget mainwinfm, mainwinmenub, mainwinpd[4], mainwincb[4];
Widget mainwinquitB, mainwinloadB, mainwinsaveB, mainwinsnqB;
Widget mainwinzmatB, mainwinlabelB, mainwinviewB;
Widget mainwinaboutB, mainwinhelpB;
Widget mainwinlabel1;
XFontStruct *mainwintitlefs;
char *titlefont;
XmFontList mainwinfontl1;
int  Nlabel, Natom;
char Link0[BUFFLEN], Headings[BUFFLEN], Comments[MAXTITLE][BUFFLEN];
int  charge, multi;

Widget aboutOkB, aboutText;
Widget helpOkB, helpText;
Widget cautionOkB, cautionText;

Widget lbledwinform0, lbledwinmenub, lbledwinpd[3], lbledwincb[3];
Widget lbledwinform1, lbledwinlabel1, lbledwinlabel2;
Widget lbledwinsw, lbledwinrc0, lbledwinswvbar;
Widget lbledwincloseB;
Widget lblednewlabelB, lbledinsB, lbledcutB, lbledcopyB;
Widget lbledpasteB, lbleddeleteB, lbledpackB, lbledclrallB;
Widget lbledsortB, lbledapplyB, lbledviewB;
int focusedLabelNo;

Widget zmatedwinform0, zmatedwinmenub, zmatedwinpd[4], zmatedwincb[4];
Widget zmatedwinform1, zmatedwinlabel[8];
Widget zmatedwinsw, zmatedwinrc0, zmatedwinswvbar;
Widget zmatedwincloseB;
Widget zmatedwinnewatomB, zmatedwininsB, zmatedwincutB, zmatedwincopyB;
Widget zmatedwinpasteB, zmatedwindelatomB, zmatedwinclrallB;
Widget zmatedwinpackB, zmatedwinapplyB, zmatedsendlabelB, zmatwinviewB;
Widget zmattempB[10];
int focusedAtomOrder;
Widget focusedAtomWidget;

Widget viewwinform, viewwinmenub;
Widget viewwinpd1, viewwinpd2, viewwincb1, viewwincb2;
Widget viewwincloseB, viewwinredrawB, viewwinresetB;
Widget viewwinpd21, viewwinaxesB, viewwinshowaxB, viewwinhideaxB;
Widget viewwinpd22, viewwingridB, viewwinshowgrB, viewwinhidegrB;
Widget viewwinpd23, viewnumberB, viewshownumberB, viewhidenumberB;
Widget viewwinzoomSC, viewwinSW, viewwinframe, viewwindrawarea;
Widget viewwinhscrollbar, viewwinvscrollbar;
long int viewwinhbar, viewwinvbar, hbar_prev, vbar_prev;
float  R[3][3], RR[3][3];
float  region, factor;
Boolean  CannotDraw;
Boolean  showAxes, showGrid, showNumbering, isTrackBallOn;
Colormap cmap;
GC gc;

Widget loadrc1, loadrc2, loadrc3;
Widget saverc1, saverc2, saverc3;
Widget loadfnamelabel, loadfnameF, doloadB, loadFileSelB, loadCancelB;
Widget savefnamelabel, savefnameF, dosaveB, saveFileSelB, saveCancelB;
Widget saveTypePd, saveOptionM, tb[NsaveType];
Boolean saveType[NsaveType];
char FileName[BUFFLEN];
Widget overWriteWin, overWriteOkB, overWriteCancelB;
Boolean overWriteOk;


struct AtomData {
  Widget AtomID;
  Widget AtomOrderID;  int AtomOrder;
  Widget NameID;  char Name[MAXNAMELANGTH+1]; int AtomNo;
  Widget Atom1ID;  char cAtom1[MAXNAMELANGTH+1];  int nAtom1;
  Widget LengthID;  char cLength[MAXLABELLENGTH+1];  float nLength; 
  Boolean UseLabelLength;
  Widget Atom2ID;  char cAtom2[MAXNAMELANGTH+1];  int nAtom2;
  Widget AngleID;  char cAngle[MAXLABELLENGTH+1];  float nAngle;
  Boolean UseLabelAngle;
  Widget Atom3ID;  char cAtom3[MAXNAMELANGTH+1];  int nAtom3;
  Widget TwistID;  char cTwist[MAXLABELLENGTH+1];  float nTwist;
  Boolean UseLabelTwist;
  float x, y, z;
  float x2, y2, z2;
  float displayX, displayY, displayZ, displayR;
} atom[MAXATOM], cutBufferAtom;

struct LabelData {
  Widget LabelrcID; 
  Widget LabelNoID;  int LabelNo;
  Widget TagID;  char Tag[MAXLABELLENGTH+1];
  Widget ValueID;  char cValue[MAXLABELLENGTH+1];  float nValue;
} label[MAXLABEL], cutBufferLabel;

struct ElementData {
  char *Name;
  float VdwRadii;
  char *ColorName;
} element[110];
