/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: initzmatwin.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void initZmatEditWin(void)
{
  int  n;
  Arg  args[20];

  /*%%%%%%%%%%*/
  n=0;
  XtSetArg(args[n], XmNhorizontalSpacing, 20); n++;
  XtSetArg(args[n], XmNrubberPositioning, TRUE); n++;
  zmatedwinform0 = XmCreateForm(zmatW, "zmateditwinform0", args, n);
  XtManageChild(zmatedwinform0);
  /***** Menu bar *****/
  n=0;
  XtSetArg(args[n], XmNisAligned, TRUE); n++;
  XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  /* XtSetArg(args[n], XmNspacing, 10); n++; */
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNtopPosition, 0); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 0); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightOffset, 0); n++;
  zmatedwinmenub = XmCreateMenuBar(zmatedwinform0, "zmateditwinmenub", args, n);
  XtManageChild(zmatedwinmenub);
  /***** Pulldown menu & cascade button *****/
  zmatedwinpd[0] = XmCreatePulldownMenu(zmatedwinmenub, "zmatedwinpd0", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, zmatedwinpd[0]); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Window")); n++;
  XtSetArg(args[n], XmNmnemonic, 'W'); n++;
  zmatedwincb[0] = XmCreateCascadeButton(zmatedwinmenub, "zmatedwincb0", args, n);
  /* XtManageChild(zmatedwincb[0]); */
  /**/
  zmatedwinpd[1] = XmCreatePulldownMenu(zmatedwinmenub, "zmatedwinpd1", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, zmatedwinpd[1]); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Edit")); n++;
  XtSetArg(args[n], XmNmnemonic, 'E'); n++;
  zmatedwincb[1] = XmCreateCascadeButton(zmatedwinmenub, "zmatedwincb1", args, n);
  /* XtManageChild(zmatedwincb[1]); */
  /**/
  zmatedwinpd[2] = XmCreatePulldownMenu(zmatedwinmenub, "zmatedwinpd2", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, zmatedwinpd[2]); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Template")); n++;
  XtSetArg(args[n], XmNmnemonic, 'T'); n++;
  zmatedwincb[2] = XmCreateCascadeButton(zmatedwinmenub, "zmatedwincb2", args, n);
  /* XtManageChild(zmatedwincb[2]); */
  /**/
  zmatedwinpd[3] = XmCreatePulldownMenu(zmatedwinmenub, "zmatedwinpd3", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, zmatedwinpd[3]); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("View")); n++;
  XtSetArg(args[n], XmNmnemonic, 'V'); n++;
  zmatedwincb[3] = XmCreateCascadeButton(zmatedwinmenub, "zmatedwincb3", args, n);
  /* XtManageChild(zmatedwincb[3]); */
  /**/
  XtManageChildren(zmatedwincb, 4);

  /********** Z-matrix input area **********/
  n=0;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopOffset, 20); n++;
  XtSetArg(args[n], XmNtopWidget, zmatedwinmenub); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 30); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightOffset, 30); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  zmatedwinform1 = XmCreateForm(zmatedwinform0, "zmateditwinform1", args, n);
  XtManageChild(zmatedwinform1);
  /** titles **/
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 10); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("No.")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
  zmatedwinlabel[0] = XmCreateLabel(zmatedwinform1, "zmateditwinlabel0", args, n);
  /* XtManageChild(zmatedwinlabel[0]); */
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 43); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Name")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
  zmatedwinlabel[1] = XmCreateLabel(zmatedwinform1, "zmateditwinlabel1", args, n);
  /* XtManageChild(zmatedwinlabel[1]); */
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 88); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Conn.r")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
  zmatedwinlabel[2] = XmCreateLabel(zmatedwinform1, "zmateditwinlabel2", args, n);
  /* XtManageChild(zmatedwinlabel[2]); */
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 145); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Length")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
  zmatedwinlabel[3] = XmCreateLabel(zmatedwinform1, "zmateditwinlabel3", args, n);
  /* XtManageChild(zmatedwinlabel[3]); */
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 205); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Conn.a")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
  zmatedwinlabel[4] = XmCreateLabel(zmatedwinform1, "zmateditwinlabel4", args, n);
  /* XtManageChild(zmatedwinlabel[4]); */
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 270); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Angle")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
  zmatedwinlabel[5] = XmCreateLabel(zmatedwinform1, "zmateditwinlabel5", args, n);
  /* XtManageChild(zmatedwinlabel[5]); */
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 326); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Conn.d")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
  zmatedwinlabel[6] = XmCreateLabel(zmatedwinform1, "zmateditwinlabel6", args, n);
  /* XtManageChild(zmatedwinlabel[6]); */
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 385); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Twist")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
  zmatedwinlabel[7] = XmCreateLabel(zmatedwinform1, "zmateditwinlabel7", args, n);
  /* XtManageChild(zmatedwinlabel[7]); */
  XtManageChildren(zmatedwinlabel, 8);

  /***** Scrolled Window *****/
  n=0;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopOffset, 0); n++;
  XtSetArg(args[n], XmNtopWidget, zmatedwinform1); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNbottomOffset, 20); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 20); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightOffset, 20); n++;
  XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
  XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;
  XtSetArg(args[n], XmNwidth, (int)(DAWIDTH*1.00)); n++;
  XtSetArg(args[n], XmNheight, (int)(DAWIDTH*0.8)); n++;
  zmatedwinsw = XmCreateScrolledWindow(zmatedwinform0, "zmateditsw", args, n);
  XtManageChild(zmatedwinsw);
  XtAddCallback(zmatedwinsw, XmNtraverseObscuredCallback, zobscuredCB, NULL);

  XtSetArg(args[0], XmNverticalScrollBar, &zmatedwinswvbar);
  XtGetValues(zmatedwinsw, args, 1);
  XtSetArg(args[0], XmNtraversalOn, FALSE);
  XtSetValues(zmatedwinswvbar, args, 1);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  zmatedwinrc0 = XmCreateRowColumn(zmatedwinsw, "zmateditwinrc0", args, 1);
  XtManageChild(zmatedwinrc0);

  XmScrolledWindowSetAreas(zmatedwinsw, NULL, NULL, zmatedwinrc0);
  /**/

  /********** Buttons **********/
  /* close */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Close"));
  XtSetArg(args[1], XmNmnemonic, 'C');
  zmatedwincloseB = XmCreatePushButton(zmatedwinpd[0], "zcloseB", args, 2);
  XtAddCallback(zmatedwincloseB, XmNactivateCallback, (XtCallbackProc)zcloseCB, NULL); 
  XtManageChild(zmatedwincloseB);
  /**/
  /* add new atom */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("NewAtom"));
  XtSetArg(args[1], XmNmnemonic, 'N');
  zmatedwinnewatomB = XmCreatePushButton(zmatedwinpd[1], "znewatomB", args, 2);
  XtAddCallback(zmatedwinnewatomB, XmNactivateCallback, (XtCallbackProc)znewatomCB, NULL); 
  XtManageChild(zmatedwinnewatomB);
  /* insert new atom */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Insert"));
  XtSetArg(args[1], XmNmnemonic, 'I');
  zmatedwininsB = XmCreatePushButton(zmatedwinpd[1], "zinsB", args, 2); 
  XtAddCallback(zmatedwininsB, XmNactivateCallback, (XtCallbackProc)zinsertCB, NULL);
  XtManageChild(zmatedwininsB);
  /* cut item & keep it in buffer */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Cut(X)"));
  XtSetArg(args[1], XmNmnemonic, 'X');
  zmatedwincutB = XmCreatePushButton(zmatedwinpd[1], "zcutB", args, 2);
  XtAddCallback(zmatedwincutB, XmNactivateCallback, (XtCallbackProc)zcutCB, NULL);
  XtManageChild(zmatedwincutB);
  /* copy item & keep it in buffer */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Copy"));
  XtSetArg(args[1], XmNmnemonic, 'C');
  zmatedwincopyB = XmCreatePushButton(zmatedwinpd[1], "zcopyB", args, 2);
  XtAddCallback(zmatedwincopyB, XmNactivateCallback, (XtCallbackProc)zcopyCB, NULL);
  XtManageChild(zmatedwincopyB);
  /* paste item from buffer */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Paste(Y)"));
  XtSetArg(args[1], XmNmnemonic, 'Y');
  zmatedwinpasteB = XmCreatePushButton(zmatedwinpd[1], "zpasteB", args, 2);
  XtAddCallback(zmatedwinpasteB, XmNactivateCallback, (XtCallbackProc)zpasteCB, NULL);
  XtManageChild(zmatedwinpasteB);
  /* delete last atom */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Delete last"));
  zmatedwindelatomB = XmCreatePushButton(zmatedwinpd[1], "zdelatomB", args, 1);
  XtAddCallback(zmatedwindelatomB, XmNactivateCallback, (XtCallbackProc)zDelLastAtomCB, NULL); 
  /*XtManageChild(zmatedwindelatomB);*/
  /* delete all atom */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Clear All"));
  XtSetArg(args[1], XmNmnemonic, 'A');
  zmatedwinclrallB = XmCreatePushButton(zmatedwinpd[1], "zClearAllB", args, 2);
  XtAddCallback(zmatedwinclrallB, XmNactivateCallback, (XtCallbackProc)zClrAllAtomsCB, NULL); 
  XtManageChild(zmatedwinclrallB);
  /* pack atom list */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Pack"));
  zmatedwinpackB = XmCreatePushButton(zmatedwinpd[1], "zpackB", args, 1); 
  XtAddCallback(zmatedwinpackB, XmNactivateCallback, (XtCallbackProc)zpackCB, NULL); 
  XtManageChild(zmatedwinpackB);
  /* send label */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Send Label"));
  XtSetArg(args[1], XmNmnemonic, 'S');
  zmatedsendlabelB = XmCreatePushButton(zmatedwinpd[1], "zsendB", args, 2); 
  XtAddCallback(zmatedsendlabelB, XmNactivateCallback, (XtCallbackProc)zsendCB, NULL); 
  XtManageChild(zmatedsendlabelB);
  /**/
  /*** select template menu ***/
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Methyl"));
  zmattempB[0] = XmCreatePushButton(zmatedwinpd[2], "zmattempB0", args, 1);
  XtAddCallback(zmattempB[0], XmNactivateCallback, (XtCallbackProc)zTemplateCB, (XtPointer)"Methyl"); 
  /**/
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Phenyl"));
  zmattempB[1] = XmCreatePushButton(zmatedwinpd[2], "zmattempB0", args, 1);
  XtAddCallback(zmattempB[1], XmNactivateCallback, (XtCallbackProc)zTemplateCB, (XtPointer)"Phenyl"); 
  /**/
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Cyclohexyl"));
  zmattempB[2] = XmCreatePushButton(zmatedwinpd[2], "zmattempB0", args, 1);
  XtAddCallback(zmattempB[2], XmNactivateCallback, (XtCallbackProc)zTemplateCB, (XtPointer)"Cyclohexyl"); 
  /**/
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Carboxyl"));
  zmattempB[3] = XmCreatePushButton(zmatedwinpd[2], "zmattempB0", args, 1);
  XtAddCallback(zmattempB[3], XmNactivateCallback, (XtCallbackProc)zTemplateCB, (XtPointer)"Carboxyl"); 
  /**/
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Amino"));
  zmattempB[4] = XmCreatePushButton(zmatedwinpd[2], "zmattempB0", args, 1);
  XtAddCallback(zmattempB[4], XmNactivateCallback, (XtCallbackProc)zTemplateCB, (XtPointer)"Amino"); 
  /**/
  XtManageChildren(zmattempB, 5);
  /**/
  /* apply */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Apply"));
  XtSetArg(args[1], XmNmnemonic, 'A');
  zmatedwinapplyB = XmCreatePushButton(zmatedwinpd[3], "zapplyB", args, 2);
  XtAddCallback(zmatedwinapplyB, XmNactivateCallback, (XtCallbackProc)zpackCB, NULL); 
  XtAddCallback(zmatedwinapplyB, XmNactivateCallback, (XtCallbackProc)zapplyCB, NULL); 
  XtAddCallback(zmatedwinapplyB, XmNactivateCallback, (XtCallbackProc)redrawCB, NULL); 
  XtManageChild(zmatedwinapplyB);
  /* view molecule */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("View Molecule"));
  XtSetArg(args[1], XmNmnemonic, 'V');
  zmatwinviewB = XmCreatePushButton(zmatedwinpd[3], "zviewB", args, 2);
  XtManageChild(zmatwinviewB);
  XtAddCallback(zmatwinviewB, XmNactivateCallback, (XtCallbackProc)viewCB, NULL); 
  /**/
}
