/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: initzmat.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void initZmatWidget(void)
{
  int i;
  char s[10];
  Arg args[10];

  for (i=1; i<MAXATOM; i++) {

    XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
    atom[i].AtomID = XmCreateRowColumn(zmatedwinrc0, "zmatrc", args, 1);
    /* XtManageChild(atom[i].AtomID); */
    XmAddTabGroup(atom[i].AtomID);

    atom[i].AtomOrder=i;
    sprintf(s, "%3i", i);
    XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized(s));
    XtSetArg(args[1], XmNtraversalOn, FALSE);
    atom[i].AtomOrderID = XmCreateLabel(atom[i].AtomID, "zmatorder", args, 2);

    XtSetArg(args[0], XmNcolumns, 5);
    XtSetArg(args[1], XmNtraversalOn, TRUE);
    atom[i].NameID = XmCreateTextField(atom[i].AtomID, "name", args, 2);
    XtAddCallback(atom[i].NameID, XmNactivateCallback, EnterAtomName, &atom[i]);
    if (i==1) {
      XtAddCallback(atom[i].NameID, XmNactivateCallback, zLastCB, NULL);
      XtAddCallback(atom[i].NameID, XmNactivateCallback, kbTravNextTGCB, NULL);
    } else {
      XtAddCallback(atom[i].NameID, XmNactivateCallback, kbTravNextCB, NULL);
    }
    XtAddCallback(atom[i].NameID, XmNlosingFocusCallback, EnterAtomName, &atom[i]);
    XtAddCallback(atom[i].NameID, XmNfocusCallback, zfocusCB, &atom[i]);

    /**/

    XtSetArg(args[0], XmNcolumns, 5);
    XtSetArg(args[1], XmNtraversalOn, TRUE);
    atom[i].Atom1ID = XmCreateTextField(atom[i].AtomID, "connr", args, 2);
    XtAddCallback(atom[i].Atom1ID, XmNactivateCallback, EnterAtomX, &atom[i]);
    XtAddCallback(atom[i].Atom1ID, XmNactivateCallback, kbTravNextCB, NULL);
    XtAddCallback(atom[i].Atom1ID, XmNlosingFocusCallback, EnterAtomX, &atom[i]); 
    XtAddCallback(atom[i].Atom1ID, XmNfocusCallback, zfocusCB, &atom[i]);

    XtSetArg(args[0], XmNcolumns, 8);
    XtSetArg(args[1], XmNtraversalOn, TRUE);
    atom[i].LengthID = XmCreateTextField(atom[i].AtomID, "dist", args, 2);
    XtAddCallback(atom[i].LengthID, XmNactivateCallback, EnterZValue, &atom[i]);
    if (i==2) {
      XtAddCallback(atom[i].LengthID, XmNactivateCallback, zLastCB, NULL);
      XtAddCallback(atom[i].LengthID, XmNactivateCallback, kbTravNextTGCB, NULL);
    } else {
      XtAddCallback(atom[i].LengthID, XmNactivateCallback, kbTravNextCB, NULL);
    }
    XtAddCallback(atom[i].LengthID, XmNlosingFocusCallback, EnterZValue, &atom[i]);
    XtAddCallback(atom[i].LengthID, XmNfocusCallback, zfocusCB, &atom[i]);

    /**/

    XtSetArg(args[0], XmNcolumns, 5);
    XtSetArg(args[1], XmNtraversalOn, TRUE);
    atom[i].Atom2ID = XmCreateTextField(atom[i].AtomID, "conna", args, 2);
    XtAddCallback(atom[i].Atom2ID, XmNactivateCallback, EnterAtomX, &atom[i]);
    XtAddCallback(atom[i].Atom2ID, XmNactivateCallback, kbTravNextCB, NULL);
    XtAddCallback(atom[i].Atom2ID, XmNlosingFocusCallback, EnterAtomX, &atom[i]);
    XtAddCallback(atom[i].Atom2ID, XmNfocusCallback, zfocusCB, &atom[i]);

    XtSetArg(args[0], XmNcolumns, 8);
    XtSetArg(args[1], XmNtraversalOn, TRUE);
    atom[i].AngleID = XmCreateTextField(atom[i].AtomID, "angle", args, 2);
    XtAddCallback(atom[i].AngleID, XmNactivateCallback, EnterZValue, &atom[i]);
    if (i==3) {
      XtAddCallback(atom[i].AngleID, XmNactivateCallback, zLastCB, NULL);
      XtAddCallback(atom[i].AngleID, XmNactivateCallback, kbTravNextTGCB, NULL);
    } else {
      XtAddCallback(atom[i].AngleID, XmNactivateCallback, kbTravNextCB, NULL);
    }
    XtAddCallback(atom[i].AngleID, XmNlosingFocusCallback, EnterZValue, &atom[i]);
    XtAddCallback(atom[i].AngleID, XmNfocusCallback, zfocusCB, &atom[i]);

    /**/

    XtSetArg(args[0], XmNcolumns, 5);
    XtSetArg(args[1], XmNtraversalOn, TRUE);
    atom[i].Atom3ID = XmCreateTextField(atom[i].AtomID, "connd", args, 2);
    XtAddCallback(atom[i].Atom3ID, XmNactivateCallback, EnterAtomX, &atom[i]);
    XtAddCallback(atom[i].Atom3ID, XmNactivateCallback, kbTravNextCB, NULL);
    XtAddCallback(atom[i].Atom3ID, XmNlosingFocusCallback, EnterAtomX, &atom[i]);
    XtAddCallback(atom[i].Atom3ID, XmNfocusCallback, zfocusCB, &atom[i]);

    XtSetArg(args[0], XmNcolumns, 8);
    XtSetArg(args[1], XmNtraversalOn, TRUE);
    atom[i].TwistID = XmCreateTextField(atom[i].AtomID, "dihedral", args, 2);
    XtAddCallback(atom[i].TwistID, XmNactivateCallback, EnterZValue, &atom[i]);
    XtAddCallback(atom[i].TwistID, XmNactivateCallback, zLastCB, NULL);
    XtAddCallback(atom[i].TwistID, XmNactivateCallback, kbTravNextTGCB, NULL);
    XtAddCallback(atom[i].TwistID, XmNlosingFocusCallback, EnterZValue, &atom[i]);
    XtAddCallback(atom[i].TwistID, XmNfocusCallback, zfocusCB, &atom[i]);

    /**/

    XtManageChild(atom[i].AtomOrderID);
    XtManageChild(atom[i].NameID);
    if (i == 1) continue;
    XtManageChild(atom[i].Atom1ID);
    XtManageChild(atom[i].LengthID);
    if (i == 2) continue;
    XtManageChild(atom[i].Atom2ID);
    XtManageChild(atom[i].AngleID);
    if (i == 3) continue;
    XtManageChild(atom[i].Atom3ID);
    XtManageChild(atom[i].TwistID);

  }
}
