/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: initview.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void initViewWin(void)
{
  int n;
  Arg args[20];

  /**//**//**//**//**//**//**//**//**//**//**//**//**//**//**/
  n=0;
  XtSetArg(args[n], XmNhorizontalSpacing, 20); n++;
  XtSetArg(args[n], XmNrubberPositioning, TRUE); n++;
  viewwinform = XmCreateForm(viewW, "viewwinform", args, n);
  XtManageChild(viewwinform);

  /********** Menu bar **********/
  n=0;
  XtSetArg(args[n], XmNisAligned, TRUE); n++;
  XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  /* XtSetArg(args[n], XmNspacing, 10); n++; */
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNtopPosition, 0); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 0); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightOffset, 0); n++;
  viewwinmenub = XmCreateMenuBar(viewwinform, "viewwinmenub", args, n);
  XtManageChild(viewwinmenub);

  /***** Pulldown menu & cascade button *****/
  viewwinpd1 = XmCreatePulldownMenu(viewwinmenub, "viewwinpd1", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, viewwinpd1); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Window")); n++;
  XtSetArg(args[n], XmNmnemonic, 'W'); n++;
  viewwincb1 = XmCreateCascadeButton(viewwinmenub, "viewwincb1", args, n);
  XtManageChild(viewwincb1);
  /**/
  viewwinpd2 = XmCreatePulldownMenu(viewwinmenub, "viewwinpd2", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, viewwinpd2); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("View")); n++;
  XtSetArg(args[n], XmNmnemonic, 'V'); n++;
  viewwincb2 = XmCreateCascadeButton(viewwinmenub, "viewwincb2", args, n);
  XtManageChild(viewwincb2);

  /********** Buttons **********/
  /* close */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Close"));
  XtSetArg(args[1], XmNmnemonic, 'C');
  viewwincloseB = XmCreatePushButton(viewwinpd1, "viewwincloseB", args, 2);
  XtAddCallback(viewwincloseB, XmNactivateCallback, (XtCallbackProc)vcloseCB, NULL); 
  XtManageChild(viewwincloseB);
  /**/
  /* re-draw view */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Re-Draw"));
  XtSetArg(args[1], XmNmnemonic, 'D');
  viewwinredrawB = XmCreatePushButton(viewwinpd2, "viewwinresetB", args, 2);
  XtAddCallback(viewwinredrawB, XmNactivateCallback, (XtCallbackProc)redrawCB, NULL); 
  XtManageChild(viewwinredrawB);
  /* reset to original view */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Reset"));
  XtSetArg(args[1], XmNmnemonic, 'R');
  viewwinresetB = XmCreatePushButton(viewwinpd2, "viewwinresetB", args, 2);
  XtAddCallback(viewwinresetB, XmNactivateCallback, (XtCallbackProc)resetviewCB, NULL); 
  XtAddCallback(viewwinresetB, XmNactivateCallback, (XtCallbackProc)redrawCB, NULL); 
  XtManageChild(viewwinresetB);
  /* xyz-axes */
  viewwinpd21 = XmCreatePulldownMenu(viewwinpd2, "viewwinpd21", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("XYZ-Axes")); n++;
  XtSetArg(args[n], XmNsubMenuId, viewwinpd21); n++;
  XtSetArg(args[n], XmNmnemonic, 'A'); n++;
  viewwinaxesB = XmCreateCascadeButton(viewwinpd2, "viewwinaxesB", args, n);
  XtManageChild(viewwinaxesB);
  /* show axes */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Show axes"));
  XtSetArg(args[1], XmNmnemonic, 'S');
  viewwinshowaxB = XmCreatePushButton(viewwinpd21, "showaxB", args, 2);
  XtAddCallback(viewwinshowaxB, XmNactivateCallback, (XtCallbackProc)axesCB, (XtPointer)SHOW); 
  XtAddCallback(viewwinshowaxB, XmNactivateCallback, (XtCallbackProc)redrawCB, NULL); 
  XtManageChild(viewwinshowaxB);
  /* hide axes */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Hide axes"));
  XtSetArg(args[1], XmNmnemonic, 'H');
  viewwinhideaxB = XmCreatePushButton(viewwinpd21, "viewwinhideaxB", args, 2);
  XtAddCallback(viewwinhideaxB, XmNactivateCallback, (XtCallbackProc)axesCB, (XtPointer)HIDE); 
  XtAddCallback(viewwinhideaxB, XmNactivateCallback, (XtCallbackProc)redrawCB, NULL); 
  XtManageChild(viewwinhideaxB);
  /* xy-plane grid */
  viewwinpd22 = XmCreatePulldownMenu(viewwinpd2, "viewwinpd22", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("XY-Grid")); n++;
  XtSetArg(args[n], XmNsubMenuId, viewwinpd22); n++;
  XtSetArg(args[n], XmNmnemonic, 'G'); n++;
  viewwingridB = XmCreateCascadeButton(viewwinpd2, "viewwingridB", args, n);
  XtManageChild(viewwingridB);
  /* show grid */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Show grid"));
  XtSetArg(args[1], XmNmnemonic, 'S');
  viewwinshowgrB = XmCreatePushButton(viewwinpd22, "showgrB", args, 2);
  XtAddCallback(viewwinshowgrB, XmNactivateCallback, (XtCallbackProc)gridCB, (XtPointer)SHOW); 
  XtAddCallback(viewwinshowgrB, XmNactivateCallback, (XtCallbackProc)redrawCB, NULL); 
  XtManageChild(viewwinshowgrB);
  /* hide axes */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Hide grid"));
  XtSetArg(args[1], XmNmnemonic, 'H');
  viewwinhidegrB = XmCreatePushButton(viewwinpd22, "hidegrB", args, 2);
  XtAddCallback(viewwinhidegrB, XmNactivateCallback, (XtCallbackProc)gridCB, (XtPointer)HIDE); 
  XtAddCallback(viewwinhidegrB, XmNactivateCallback, (XtCallbackProc)redrawCB, NULL); 
  XtManageChild(viewwinhidegrB);
  /* atom numbering */
  viewwinpd23 = XmCreatePulldownMenu(viewwinpd2, "viewwinpd23", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Numbering")); n++;
  XtSetArg(args[n], XmNsubMenuId, viewwinpd23); n++;
  XtSetArg(args[n], XmNmnemonic, 'N'); n++;
  viewnumberB = XmCreateCascadeButton(viewwinpd2, "viewnumberB", args, n);
  XtManageChild(viewnumberB);
  /* show numbering */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Show numbering"));
  XtSetArg(args[1], XmNmnemonic, 'S');
  viewshownumberB = XmCreatePushButton(viewwinpd23, "shownumberB", args, 2);
  XtAddCallback(viewshownumberB, XmNactivateCallback, (XtCallbackProc)numberingCB, (XtPointer)SHOW); 
  XtAddCallback(viewshownumberB, XmNactivateCallback, (XtCallbackProc)redrawCB, NULL); 
  XtManageChild(viewshownumberB);
  /* hide numbering */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Hide numbering"));
  XtSetArg(args[1], XmNmnemonic, 'H');
  viewhidenumberB = XmCreatePushButton(viewwinpd23, "hidenumberB", args, 2);
  XtAddCallback(viewhidenumberB, XmNactivateCallback, (XtCallbackProc)numberingCB, (XtPointer)HIDE); 
  XtAddCallback(viewhidenumberB, XmNactivateCallback, (XtCallbackProc)redrawCB, NULL); 
  XtManageChild(viewhidenumberB);

  /***** zoom *****/
  n=0;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopWidget, viewwinmenub); n++;
  XtSetArg(args[n], XmNtopOffset, 0); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
  XtSetArg(args[n], XmNrightWidget, viewwinmenub); n++;
  XtSetArg(args[n], XmNrightOffset, 20); n++;
  XtSetArg(args[n], XmNscaleWidth, 200); n++;
  XtSetArg(args[n], XmNmaximum, 200); n++;
  XtSetArg(args[n], XmNvalue, 100); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(args[n], XmNtitleString, XmStringCreateLocalized("Zoom")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++; 
  viewwinzoomSC = XmCreateScale(viewwinform, "viewwinzoomSC", args, n);
  XtManageChild(viewwinzoomSC);
  XtAddCallback(viewwinzoomSC, XmNvalueChangedCallback, (XtCallbackProc)zoomCB, NULL); 
  XtAddCallback(viewwinzoomSC, XmNvalueChangedCallback, (XtCallbackProc)redrawCB, NULL); 

  /********** scrolled window **********/
  n=0;
  XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopOffset, 0); n++;
  XtSetArg(args[n], XmNtopWidget, viewwinzoomSC); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNbottomOffset, 20); n++;
  XtSetArg(args[n], XmNscrolledWindowMarginWidth, 20); n++;
  /*XtSetArg(args[n], XmNscrolledWindowMarginHeight, 20); n++;*/
  viewwinSW = XmCreateScrolledWindow(viewwinform, "viewwinSW", args, n);
  XtManageChild(viewwinSW);
  /* frame */
  n=0;
  XtSetArg(args[n], XmNshadowThickness, 5); n++;
  XtSetArg(args[n], XmNshadowType, XmSHADOW_ETCHED_IN); n++;
  viewwinframe = XmCreateFrame(viewwinSW, "fr", args, n);
  XtManageChild(viewwinframe);
  /* molecular drawing area */
  n=0;
  XtSetArg(args[n], XmNwidth, (XtArgVal)DAWIDTH); n++;
  XtSetArg(args[n], XmNheight, (XtArgVal)DAWIDTH); n++;
  viewwindrawarea = XmCreateDrawingArea(viewwinframe, "viewwindrawarea", args, n);
  XtManageChild(viewwindrawarea);
  /**/
  XtAddEventHandler(viewwindrawarea, KeyPressMask, FALSE, (XtEventHandler)trackBallOnOffEH, (XtPointer)KEYPRESS);
  XtAddEventHandler(viewwindrawarea, KeyReleaseMask, FALSE, (XtEventHandler)trackBallOnOffEH, (XtPointer)KEYRELEASE);
  /***** scroll bar *****/
  viewwinhbar=viewwinvbar=0;
  hbar_prev=vbar_prev=0;
  n=0;
  XtSetArg(args[n], XmNminimum, -181); n++;
  XtSetArg(args[n], XmNmaximum, 191); n++;
  XtSetArg(args[n], XmNvalue, viewwinhbar); n++;
  XtSetArg(args[n], XmNsliderSize, 10); n++;
  XtSetArg(args[n], XmNincrement, 2); n++;
  XtSetArg(args[n], XmNpageIncrement, 20); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  viewwinhscrollbar = XmCreateScrollBar(viewwinSW, "viewwinhbar", args, n);
  XtManageChild(viewwinhscrollbar);
  XtAddCallback(viewwinhscrollbar, XmNvalueChangedCallback, (XtCallbackProc)barCB, (XtPointer)HBAR);
  XtAddCallback(viewwinhscrollbar, XmNvalueChangedCallback, (XtCallbackProc)redrawCB, NULL);
  /**/
  n=0;
  XtSetArg(args[n], XmNminimum, -181); n++;
  XtSetArg(args[n], XmNmaximum, 191); n++;
  XtSetArg(args[n], XmNvalue, viewwinvbar); n++;
  XtSetArg(args[n], XmNsliderSize, 10); n++;
  XtSetArg(args[n], XmNincrement, 2); n++;
  XtSetArg(args[n], XmNpageIncrement, 20); n++;
  XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
  viewwinvscrollbar = XmCreateScrollBar(viewwinSW, "vbar", args, n);
  XtAddCallback(viewwinvscrollbar, XmNvalueChangedCallback, (XtCallbackProc)barCB, (XtPointer)VBAR);
  XtAddCallback(viewwinvscrollbar, XmNvalueChangedCallback, (XtCallbackProc)redrawCB, NULL);
  XtManageChild(viewwinvscrollbar);
  /**/
  XmScrolledWindowSetAreas(viewwinSW, viewwinhscrollbar, viewwinvscrollbar, viewwinframe);
  XtAddCallback(viewwindrawarea, XmNexposeCallback, (XtCallbackProc)redrawCB, NULL);
  XtAddCallback(viewwindrawarea, XmNresizeCallback, (XtCallbackProc)redrawCB, NULL);
  /**//**//**//**//**//**//**//**//**//**/

}
