/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: initmain.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void initMain(void)
{
  int n;
  Arg  args[20];

  /***** main window frame *****/
  n=0;
  XtSetArg(args[n], XmNhorizontalSpacing, 20); n++;
  XtSetArg(args[n], XmNrubberPositioning, TRUE); n++;
  mainwinfm = XmCreateForm(toplevel, "mainwinfm", args, n);
  /* XtManageChild(mainwinfm); */

  /***** main window menu bar *****/
  n=0;
  XtSetArg(args[n], XmNisAligned, TRUE); n++;
  XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  /* XtSetArg(args[n], XmNspacing, 10); n++; */
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNtopPosition, 0); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 0); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightOffset, 0); n++;
  mainwinmenub = XmCreateMenuBar(mainwinfm, "mainwinmenub", args, n);
  XtManageChild(mainwinmenub);

  /***** Pulldown menu & cascade button *****/
  mainwinpd[0] = XmCreatePulldownMenu(mainwinmenub, "mainwinpd0", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, mainwinpd[0]); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("File")); n++;
  XtSetArg(args[n], XmNmnemonic, 'F'); n++;
  mainwincb[0] = XmCreateCascadeButton(mainwinmenub, "mainwincb0", args, n);
  /* XtManageChild(mainwincb[0]);*/
  /**/
  mainwinpd[1] = XmCreatePulldownMenu(mainwinmenub, "mainwinpd1", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, mainwinpd[1]); n++;
  XtSetArg(args[n], XmNmnemonic, 'E'); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Edit")); n++;
  mainwincb[1] = XmCreateCascadeButton(mainwinmenub, "mainwincb1", args, n);
  /* XtManageChild(mainwincb[1]); */
  /**/
  mainwinpd[2] = XmCreatePulldownMenu(mainwinmenub, "mainwinpd2", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, mainwinpd[2]); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("View")); n++;
  XtSetArg(args[n], XmNmnemonic, 'V'); n++;
  mainwincb[2] = XmCreateCascadeButton(mainwinmenub, "mainwincb2", args, n);
  /* XtManageChild(mainwincb[2]); */
  /**/
  mainwinpd[3] = XmCreatePulldownMenu(mainwinmenub, "mainwinpd3", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, mainwinpd[3]); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Help")); n++;
  XtSetArg(args[n], XmNmnemonic, 'H'); n++;
  mainwincb[3] = XmCreateCascadeButton(mainwinmenub, "mainwincb3", args, n);
  /* XtManageChild(mainwincb[3]); */
  /**/
  XtManageChildren(mainwincb, 4);

  /********** Buttons **********/
  /* load data */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Load File"));
  XtSetArg(args[1], XmNmnemonic, 'L');
  mainwinloadB = XmCreatePushButton(mainwinpd[0], "mainwinloadB", args, 2); 
  XtManageChild(mainwinloadB);
  /* set-up load window */
  n=0;
  XtSetArg(args[n], XmNautoUnmanage, False); n++;
  XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  loadW = XmCreateBulletinBoardDialog(toplevel, "loadwin", args, n); 
  XtAddCallback(mainwinloadB, XmNactivateCallback, (XtCallbackProc)loadCB, NULL); 
  /* save data */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Save Data"));
  XtSetArg(args[1], XmNmnemonic, 'S');
  mainwinsaveB = XmCreatePushButton(mainwinpd[0], "mainwinsaveB", args, 2); 
  XtManageChild(mainwinsaveB);
  /* set-up save window */
  n=0;
  XtSetArg(args[n], XmNautoUnmanage, False); n++;
  XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  saveW = XmCreateBulletinBoardDialog(toplevel, "savewin", args, n); 
  XtAddCallback(mainwinsaveB, XmNactivateCallback, (XtCallbackProc)saveCB, NULL); 
  /* quit KUMI */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Quit KUMI"));
  XtSetArg(args[1], XmNmnemonic, 'Q');
  mainwinquitB = XmCreatePushButton(mainwinpd[0], "mainwinquitB", args, 2);
  XtAddCallback(mainwinquitB, XmNactivateCallback, (XtCallbackProc)quitCB, NULL); 
  XtManageChild(mainwinquitB);
  /* save & quit KUMI */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("SAve & Quit"));
  XtSetArg(args[1], XmNmnemonic, 'A');
  mainwinsnqB = XmCreatePushButton(mainwinpd[0], "mainwinsnqB", args, 2);
  XtAddCallback(mainwinsnqB, XmNactivateCallback, (XtCallbackProc)saveCB, NULL); 
  XtAddCallback(mainwinsnqB, XmNactivateCallback, (XtCallbackProc)quitCB, NULL); 
  XtManageChild(mainwinsnqB);
  /**/
  /* Z-matrix edit window */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Zmatrix"));
  XtSetArg(args[1], XmNmnemonic, 'Z');
  mainwinzmatB = XmCreatePushButton(mainwinpd[1], "mainwinzmatB", args, 2);
  XtManageChild(mainwinzmatB);
  /* set-up Z-matrix window */
  n=0;
  XtSetArg(args[n], XmNautoUnmanage, False); n++;
  XtSetArg(args[n], XmNdialogStyle, XmDIALOG_MODELESS); n++;
  XtSetArg(args[n], XmNhorizontalSpacing, 30); n++;
  XtSetArg(args[n], XmNverticalSpacing, 30); n++;
  zmatW = XmCreateFormDialog(toplevel, "zmatW", args, n); 
  XtAddCallback(mainwinzmatB, XmNactivateCallback, (XtCallbackProc)zmatCB, NULL); 
  /* label edit window */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Label"));
  XtSetArg(args[1], XmNmnemonic, 'L');
  mainwinlabelB = XmCreatePushButton(mainwinpd[1], "mainwinlabelB", args, 2);
  XtManageChild(mainwinlabelB);
  /* set-up label window */
  n=0;
  XtSetArg(args[n], XmNautoUnmanage, False); n++;
  XtSetArg(args[n], XmNdialogStyle, XmDIALOG_MODELESS); n++;
  XtSetArg(args[n], XmNhorizontalSpacing, 30); n++;
  XtSetArg(args[n], XmNverticalSpacing, 30); n++;
  labeleditW = XmCreateFormDialog(toplevel, "labeledit", args, n); 
  XtAddCallback(mainwinlabelB, XmNactivateCallback, (XtCallbackProc)labeleditCB, NULL); 
  /**/
  /* view molecule */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("View Molecule"));
  XtSetArg(args[1], XmNmnemonic, 'V');
  mainwinviewB = XmCreatePushButton(mainwinpd[2], "mainwinviewB", args, 2);
  XtManageChild(mainwinviewB);
  /* set-up view window */
  n=0;
  XtSetArg(args[n], XmNautoUnmanage, False); n++;
  XtSetArg(args[n], XmNdialogStyle, XmDIALOG_MODELESS); n++;
  XtSetArg(args[n], XmNhorizontalSpacing, 30); n++;
  XtSetArg(args[n], XmNverticalSpacing, 30); n++;
  viewW = XmCreateFormDialog(toplevel, "viewwin", args, n); 
  XtAddCallback(mainwinviewB, XmNactivateCallback, (XtCallbackProc)viewCB, NULL); 
  /**/
  /* about this program */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("About"));
  XtSetArg(args[1], XmNmnemonic, 'A');
  mainwinaboutB = XmCreatePushButton(mainwinpd[3], "aboutB", args, 2);
  XtManageChild(mainwinaboutB);
  /* set-up about... window */
  n=0;
  XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(args[n], XmNdefaultButtonType, XmDIALOG_NONE); n++;
  aboutW = XmCreateMessageDialog(toplevel, "aboutW", args, n); 
  XtAddCallback(mainwinaboutB, XmNactivateCallback, (XtCallbackProc)aboutCB, NULL); 
  /* help */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Help"));
  XtSetArg(args[1], XmNmnemonic, 'H');
  mainwinhelpB = XmCreatePushButton(mainwinpd[3], "helpB", args, 2);
  XtManageChild(mainwinhelpB);
  /* set-up help... window */
  n=0;
  XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
  XtSetArg(args[n], XmNdefaultButtonType, XmDIALOG_NONE); n++;
  helpW = XmCreateMessageDialog(toplevel, "helpW", args, n); 
  XtAddCallback(mainwinhelpB, XmNactivateCallback, (XtCallbackProc)helpCB, NULL); 

  /***** TITLE *****/
  titlefont="-*-helvetica-bold-o-normal-*-24-*-*-*-*-*-iso8859-1";
  mainwintitlefs = XLoadQueryFont(XtDisplay(toplevel), titlefont);
  mainwinfontl1 = XmFontListCreate(mainwintitlefs, "titleset");
  n=0;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopWidget, mainwinmenub); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNfontList, mainwinfontl1); n++; 
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Z-matrix Editor")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++; 
  mainwinlabel1 = XmCreateLabel(mainwinfm, "mainwinlabel1", args, n); 
  XtManageChild(mainwinlabel1);
  /*%%%%%%%%%%*/
}
