/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: initlbledwin.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void initLabelEditWin(void)
{
  int  n;
  Arg  args[20];

  /*%%%%%%%%%%*/
  n=0;
  XtSetArg(args[n], XmNhorizontalSpacing, 20); n++;
  XtSetArg(args[n], XmNrubberPositioning, TRUE); n++;
  lbledwinform0 = XmCreateForm(labeleditW, "labeleditwinform0", args, n);
  XtManageChild(lbledwinform0);

  /* LabelEdit Win Menu bar */
  n=0;
  XtSetArg(args[n], XmNisAligned, TRUE); n++;
  XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  /* XtSetArg(args[n], XmNspacing, 10); n++; */
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNtopPosition, 0); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 0); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightOffset, 0); n++;
  lbledwinmenub = XmCreateMenuBar(lbledwinform0, "labeleditwinmenub", args, n);
  XtManageChild(lbledwinmenub);

  /** Pulldown menu & cascade button **/
  lbledwinpd[0] = XmCreatePulldownMenu(lbledwinmenub, "labeleditwinpd0", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, lbledwinpd[0]); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Window")); n++;
  XtSetArg(args[n], XmNmnemonic, 'W'); n++;
  lbledwincb[0] = XmCreateCascadeButton(lbledwinmenub, "labeleditwincb0", args, n);
  /* XtManageChild(lbledwincb[0]); */
  /**/
  lbledwinpd[1] = XmCreatePulldownMenu(lbledwinmenub, "labeleditwinpd1", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, lbledwinpd[1]); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Edit")); n++;
  XtSetArg(args[n], XmNmnemonic, 'E'); n++;
  lbledwincb[1] = XmCreateCascadeButton(lbledwinmenub, "labeleditwincb1", args, n);
  /* XtManageChild(lbledwincb[1]); */
  /**/
  lbledwinpd[2] = XmCreatePulldownMenu(lbledwinmenub, "labeleditwinpd2", NULL, 0);
  n=0;
  XtSetArg(args[n], XmNsubMenuId, lbledwinpd[2]); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("View")); n++;
  XtSetArg(args[n], XmNmnemonic, 'V'); n++;
  lbledwincb[2] = XmCreateCascadeButton(lbledwinmenub, "labeleditwincb2", args, n);
  /* XtManageChild(lbledwincb[2]); */
  XtManageChildren(lbledwincb, 3);
  /**/

  /********** Label input area **********/
  /* title */
  n=0;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopOffset, 20); n++;
  XtSetArg(args[n], XmNtopWidget, lbledwinmenub); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 60); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  lbledwinform1 = XmCreateForm(lbledwinform0, "labeleditwinform1", args, n);
  XtManageChild(lbledwinform1);
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 10); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Label")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
  lbledwinlabel1 = XmCreateLabel(lbledwinform1, "labeleditwinlabel1", args, n);
  XtManageChild(lbledwinlabel1);
  n=0;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 150); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Value")); n++;
  XtSetArg(args[n], XmNtraversalOn, FALSE); n++;
  lbledwinlabel2 = XmCreateLabel(lbledwinform1, "labeleditwinlabel2", args, n);
  XtManageChild(lbledwinlabel2);

  /***** Scrolled Window *****/
  n=0;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(args[n], XmNtopOffset, 0); n++;
  XtSetArg(args[n], XmNtopWidget, lbledwinform1); n++;
  XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNbottomOffset, 20); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftOffset, 20); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightOffset, 20); n++;
  XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
  XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;
  XtSetArg(args[n], XmNwidth, (int)(DAWIDTH*0.70)); n++;
  XtSetArg(args[n], XmNheight, (int)(DAWIDTH*0.8)); n++;
  lbledwinsw = XmCreateScrolledWindow(lbledwinform0, "labeleditwinsw", args, n);
  XtManageChild(lbledwinsw);
  XtAddCallback(lbledwinsw, XmNtraverseObscuredCallback, lobscuredCB, NULL);

  XtSetArg(args[0], XmNverticalScrollBar, &lbledwinswvbar);
  XtGetValues(lbledwinsw, args, 1);
  /*printf("|%s|%s|\n", XtName(lbledwinsw), XtName(lbledwinswvbar));*/
  XtSetArg(args[0], XmNtraversalOn, FALSE);
  XtSetValues(lbledwinswvbar, args, 1);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  lbledwinrc0 = XmCreateRowColumn(lbledwinsw, "labeleditwinrc0", args, 1);
  XtManageChild(lbledwinrc0);

  XmScrolledWindowSetAreas(lbledwinsw, NULL, NULL, lbledwinrc0);
  /**/

  /********** Buttons **********/
  /* close */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Close"));
  XtSetArg(args[1], XmNmnemonic, 'C');
  lbledwincloseB = XmCreatePushButton(lbledwinpd[0], "lcloseB", args, 2);
  XtAddCallback(lbledwincloseB, XmNactivateCallback, (XtCallbackProc)lcloseCB, NULL); 
  XtManageChild(lbledwincloseB);
  /**/
  /* add new label */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("NewLabel"));
  XtSetArg(args[1], XmNmnemonic, 'N');
  lblednewlabelB = XmCreatePushButton(lbledwinpd[1], "lnewlabelB", args, 2); 
  XtAddCallback(lblednewlabelB, XmNactivateCallback, (XtCallbackProc)lnewlabelCB, lbledwinrc0); 
  XtManageChild(lblednewlabelB);
  /* insert new label */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Insert"));
  XtSetArg(args[1], XmNmnemonic, 'I');
  lbledinsB = XmCreatePushButton(lbledwinpd[1], "linsertB", args, 2); 
  XtAddCallback(lbledinsB, XmNactivateCallback, (XtCallbackProc)linsertCB, lbledwinrc0); 
  XtManageChild(lbledinsB);
  /* cut item & keep it in buffer */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Cut(X)"));
  XtSetArg(args[1], XmNmnemonic, 'X');
  lbledcutB = XmCreatePushButton(lbledwinpd[1], "lcutB", args, 2); 
  XtAddCallback(lbledcutB, XmNactivateCallback, (XtCallbackProc)lcutCB, lbledwinrc0);
  XtManageChild(lbledcutB);
  /* copy item & keep it in buffer */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Copy"));
  XtSetArg(args[1], XmNmnemonic, 'C');
  lbledcopyB = XmCreatePushButton(lbledwinpd[1], "lcopyB", args, 2); 
  XtAddCallback(lbledcopyB, XmNactivateCallback, (XtCallbackProc)lcopyCB, lbledwinrc0);
  XtManageChild(lbledcopyB);
  /* paste item from buffer */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Paste(Y)"));
  XtSetArg(args[1], XmNmnemonic, 'Y');
  lbledpasteB = XmCreatePushButton(lbledwinpd[1], "lpasteB", args, 2); 
  XtAddCallback(lbledpasteB, XmNactivateCallback, (XtCallbackProc)lpasteCB, lbledwinrc0);
  XtManageChild(lbledpasteB);
  /* delete last item */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Delete last"));
  lbleddeleteB = XmCreatePushButton(lbledwinpd[1], "ldeleteB", args, 1); 
  XtAddCallback(lbleddeleteB, XmNactivateCallback, (XtCallbackProc)lDelLastLabelCB, lbledwinrc0); 
  /*XtManageChild(lbleddeleteB);*/
  /* clear All labels */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Clear All"));
  XtSetArg(args[1], XmNmnemonic, 'A');
  lbledclrallB = XmCreatePushButton(lbledwinpd[1], "lClearAllB", args, 2); 
  XtAddCallback(lbledclrallB, XmNactivateCallback, (XtCallbackProc)lClrAllLabelsCB, lbledwinrc0); 
  XtManageChild(lbledclrallB);
  /* pack items */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Pack"));
  lbledpackB = XmCreatePushButton(lbledwinpd[1], "lpackB", args, 1); 
  XtAddCallback(lbledpackB, XmNactivateCallback, (XtCallbackProc)lpackCB, lbledwinrc0);
  XtManageChild(lbledpackB);
  /* sort items */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Sort"));
  lbledsortB = XmCreatePushButton(lbledwinpd[1], "lsortB", args, 1); 
  /* XtAddCallback(lbledsortB, XmNactivateCallback, (XtCallbackProc)lsortCB, lbledwinrc0); */
  /*XtManageChild(lbledsortB);*/
  /**/
  /* apply */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Apply"));
  XtSetArg(args[1], XmNmnemonic, 'A');
  lbledapplyB = XmCreatePushButton(lbledwinpd[2], "lapplyB", args, 2);
  XtAddCallback(lbledapplyB, XmNactivateCallback, (XtCallbackProc)lapplyCB, NULL);
  XtAddCallback(lbledapplyB, XmNactivateCallback, (XtCallbackProc)redrawCB, NULL);
  XtManageChild(lbledapplyB);
  /* view molecule */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("View Molecule"));
  XtSetArg(args[1], XmNmnemonic, 'V');
  lbledviewB = XmCreatePushButton(lbledwinpd[2], "lviewB", args, 2);
  XtManageChild(lbledviewB);
  XtAddCallback(lbledviewB, XmNactivateCallback, (XtCallbackProc)viewCB, NULL);
  /**/
}
