/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: initlabel.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void initLabelWidget(void)
{
  int  i;
  Arg  args[20];
  char s[10];

  for (i=1; i<MAXLABEL; i++) {

    XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
    label[i].LabelrcID = XmCreateRowColumn(lbledwinrc0, "labelrc", args, 1);
    /* XtManageChild(label[i].LabelrcID); */
    XmAddTabGroup(label[i].LabelrcID);

    label[i].LabelNo=i;
    sprintf(s, "%3i", i);
    XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized(s));
    XtSetArg(args[1], XmNtraversalOn, FALSE);
    label[i].LabelNoID = XmCreateLabel(label[i].LabelrcID, "labelno", args, 2);
    XtManageChild(label[i].LabelNoID);

    XtSetArg(args[0], XmNcolumns, 20);
    XtSetArg(args[1], XmNtraversalOn, TRUE);
    label[i].TagID = XmCreateTextField(label[i].LabelrcID, "labeltag", args, 2);
    XtAddCallback(label[i].TagID, XmNactivateCallback, EnterTag, &label[i]);
    XtAddCallback(label[i].TagID, XmNactivateCallback, kbTravNextCB, &label[i]);
    XtAddCallback(label[i].TagID, XmNlosingFocusCallback, EnterTag, &label[i]);
    XtAddCallback(label[i].TagID, XmNfocusCallback, lfocusCB, &label[i]);
    XtManageChild(label[i].TagID);

    XmTextFieldSetString(label[i].TagID, "");
    strcpy(label[i].Tag, "");

    XtSetArg(args[0], XmNcolumns, 20);
    XtSetArg(args[1], XmNtraversalOn, TRUE);
    label[i].ValueID=XmCreateTextField(label[i].LabelrcID, "labelval", args, 2);
    XtAddCallback(label[i].ValueID, XmNactivateCallback, EnterValue, &label[i]);
    XtAddCallback(label[i].ValueID, XmNactivateCallback, lLastCB, &label[i]);
    XtAddCallback(label[i].ValueID, XmNactivateCallback, kbTravNextTGCB, &label[i]);
    XtAddCallback(label[i].ValueID, XmNlosingFocusCallback, EnterValue, &label[i]);
    XtAddCallback(label[i].ValueID, XmNfocusCallback, lfocusCB, &label[i]);
    XtManageChild(label[i].ValueID);

    XmTextFieldSetString(label[i].ValueID, "");
    strcpy(label[i].cValue, "");
    label[i].nValue=0;

  }

}

