/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: initfile.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void initFile(void)
{
  int  n, i;
  Arg  args[20];
  Widget helpB;

  /***** load load load load load *****//***** load load load load load *****/
  /***** load load load load load *****//***** load load load load load *****/
  n=0;
  XtSetArg(args[n], XmNorientation, XmVERTICAL); n++; 
  XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
  XtSetArg(args[n], XmNspacing, 15); n++; 
  XtSetArg(args[n], XmNmarginWidth, 30); n++;
  XtSetArg(args[n], XmNmarginHeight, 20); n++; 
  loadrc1 = XmCreateRowColumn(loadW, "loadrc1", args, n);
  XtManageChild(loadrc1);
  /*** input filename form ***/
  n=0;
  XtSetArg(args[n], XmNmarginWidth, 10); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  loadrc2 = XmCreateRowColumn(loadrc1, "loadrc2", args, n);
  XtManageChild(loadrc2);
  /* label */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("File Name:"));
  XtSetArg(args[1], XmNtraversalOn, FALSE);
  loadfnamelabel = XmCreateLabel(loadrc2, "loadfnamelabel", args, 2);
  XtManageChild(loadfnamelabel);
  /* input text */
  XtSetArg(args[0], XmNrightAttachment, XmATTACH_FORM);
  loadfnameF = XmCreateTextField(loadrc2, "loadfnameF", args, 1);
  XtManageChild(loadfnameF);
  XmAddTabGroup(loadfnameF);
  /*** Buttons ***/
  n=0; 
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
  XtSetArg(args[n], XmNisAligned, TRUE); n++;
  XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  XtSetArg(args[n], XmNmarginWidth, 20); n++;
  XtSetArg(args[n], XmNspacing, 20); n++;
  loadrc3 = XmCreateRowColumn(loadrc1, "loadrc3", args, n);
  XtManageChild(loadrc3);
  /* do load */
  n=0;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Load")); n++;
  doloadB = XmCreatePushButton(loadrc3, "doloadB", args, n);
  XtManageChild(doloadB); 
  XmAddTabGroup(doloadB);
  XtAddCallback(doloadB, XmNactivateCallback, (XtCallbackProc)doloadCB, NULL);
  XtAddCallback(doloadB, XmNactivateCallback, (XtCallbackProc)closeWinCB, loadW); 
  /* file selection */
  n=0;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("File")); n++;
  loadFileSelB = XmCreatePushButton(loadrc3, "loadfileselB", args, n);
  XtManageChild(loadFileSelB);
  XmAddTabGroup(loadFileSelB);
  XtAddCallback(loadFileSelB, XmNactivateCallback, (XtCallbackProc)fileselCB, loadW); 
  /* cancel */
  n=0;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Cancel")); n++;
  loadCancelB = XmCreatePushButton(loadrc3, "loadCancelB", args, n);
  XtManageChild(loadCancelB); 
  XmAddTabGroup(loadCancelB);
  XtAddCallback(loadCancelB, XmNactivateCallback, (XtCallbackProc)closeWinCB, loadW); 

  /***** save save save save save *****//***** save save save save save *****/
  /***** save save save save save *****//***** save save save save save *****/
  n=0;
  XtSetArg(args[n], XmNorientation, XmVERTICAL); n++; 
  XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
/*  XtSetArg(args[n], XmNspacing, 15); n++; */
  XtSetArg(args[n], XmNmarginWidth, 30); n++;
  XtSetArg(args[n], XmNmarginHeight, 20); n++; 
  saverc1 = XmCreateRowColumn(saveW, "saverc1", args, n);
  XtManageChild(saverc1);
  /*** select data format as Z-matrix/Cartesian ***/
  n=0;
  XtSetArg(args[n], XmNmarginWidth, 10); n++;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("File Type: ")); n++;
  saveOptionM = XmCreateOptionMenu(saverc1, "saveOptionM", args, n);
  n=0;
  saveTypePd = XmCreatePulldownMenu(saverc1, "saveTypePdMenu", args, n);
  XtVaSetValues(saveOptionM, XmNsubMenuId, saveTypePd, NULL);
  XtManageChild(saveOptionM);
  XtAddCallback(saveTypePd, XmNentryCallback, toggleCB, NULL);
  /**/
  for(i=0; i<NsaveType; i++) saveType[i]=FALSE;
  saveType[0]=TRUE;
  /**/
  XtSetArg(args[0], XmNset, (XtArgVal)True);
  XtSetArg(args[1], XmNlabelString, XmStringCreateLocalized("Gaussian Z-matrix"));
  tb[0] = XmCreatePushButton(saveTypePd, "tb0", args, 2);
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("MOPAC Z-matrix"));
  tb[1] = XmCreatePushButton(saveTypePd, "tb1", args, 1);
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("Cartesian"));
  tb[2] = XmCreatePushButton(saveTypePd, "tb2", args, 1);
  XtManageChildren(tb, NsaveType);
  /*** input filename form ***/
  n=0;
  XtSetArg(args[n], XmNmarginWidth, 10); n++;
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  saverc2 = XmCreateRowColumn(saverc1, "saverc2", args, n);
  XtManageChild(saverc2);
  /* label */
  XtSetArg(args[0], XmNlabelString, XmStringCreateLocalized("File Name:"));
  XtSetArg(args[1], XmNtraversalOn, FALSE);
  savefnamelabel = XmCreateLabel(saverc2, "savefnamelabel", args, 2);
  XtManageChild(savefnamelabel);
  /* input text */
  n=0;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  savefnameF = XmCreateTextField(saverc2, "savefnameF", args, n);
  XtManageChild(savefnameF);
  XmAddTabGroup(savefnameF);
  XtAddCallback(savefnameF, XmNactivateCallback, kbTravNextTGCB, NULL); 
  /*** Buttons ***/
  n=0; 
  XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;
  XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
  XtSetArg(args[n], XmNisAligned, TRUE); n++;
  XtSetArg(args[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
  XtSetArg(args[n], XmNmarginWidth, 20); n++;
  XtSetArg(args[n], XmNspacing, 20); n++;
  saverc3 = XmCreateRowColumn(saverc1, "saverc3", args, n);
  XtManageChild(saverc3);
  /* do save */
  n=0;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Save")); n++;
  dosaveB = XmCreatePushButton(saverc3, "dosaveB", args, n);
  XmAddTabGroup(dosaveB);
  XtManageChild(dosaveB); 
  XtAddCallback(dosaveB, XmNactivateCallback, (XtCallbackProc)dosaveCB, NULL);
  XtAddCallback(dosaveB, XmNactivateCallback, (XtCallbackProc)closeWinCB, saveW);
  /* file selection */
  n=0;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("File")); n++;
  saveFileSelB = XmCreatePushButton(saverc3, "savefileselB", args, n);
  XtManageChild(saveFileSelB);
  XmAddTabGroup(saveFileSelB);
  XtAddCallback(saveFileSelB, XmNactivateCallback, (XtCallbackProc)fileselCB, saveW); 
  /* cancel */
  n=0;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("Cancel")); n++;
  saveCancelB = XmCreatePushButton(saverc3, "saveCancelB", args, n);
  XtManageChild(saveCancelB);
  XmAddTabGroup(saveCancelB);
  XtAddCallback(saveCancelB, XmNactivateCallback, (XtCallbackProc)closeWinCB, saveW);

  /***** save:overwrite save:overwrite save:overwrite *****/
  /***** save:overwrite save:overwrite save:overwrite *****/
  n=0;
  XtSetArg(args[n], XmNmessageString, XmStringCreate("File Exist !   Over write ?", XmSTRING_DEFAULT_CHARSET) ); n++;
  XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  overWriteWin=XmCreateMessageDialog(toplevel, "overwritewin", args, n);
  /*XtManageChild(overWriteWin);*/
  helpB = XmMessageBoxGetChild(overWriteWin, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(helpB);
  overWriteOkB = XmMessageBoxGetChild(overWriteWin, XmDIALOG_OK_BUTTON);
  n=0;
  XtSetArg(args[n], XmNlabelString, XmStringCreateLocalized("OverWrite")); n++;
  XtSetArg(args[n], XmNtraversalOn, TRUE); n++;
  XtSetValues(overWriteOkB, args, n);
  XtAddCallback(overWriteOkB, XmNactivateCallback, (XtCallbackProc)overWriteCB, (XtPointer)TRUE);
  overWriteCancelB = XmMessageBoxGetChild(overWriteWin, XmDIALOG_CANCEL_BUTTON);
  n=0;
  XtSetArg(args[n], XmNtraversalOn, TRUE); n++;
  XtSetValues(overWriteCancelB, args, n);
  XtAddCallback(overWriteCancelB, XmNactivateCallback, (XtCallbackProc)overWriteCB, (XtPointer)FALSE);
  /**/
}
