/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: help.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void helpCB(Widget w, XtPointer clientData, XtPointer callData)
{
  Arg args[10];

  static char helpmessage[] =
  "A brief instruction guide to Z-matrix Editor ``KUMI''.\n"
  "Please read detaile \n"
  "\n(I) Select Function from Main Menu Window, such as: \n"
  "  [File]-[Load File]\n"
  "        -[Save Data]\n"
  "        -[Quit KUMI]\n"
  "        -[SAve & Quit]\n"
  "  [Edit]-[Z-matrix]\n"
  "        -[Label]\n"
  "  [View]-[View Molecule]\n"
  "  [Help]-[About]\n"
  "        -[Help]\n"
  "\n(II) Then input Z-matrix & Labels at sub-windows \n"
  "to construct your molecule with a 3D molecular view.\n"
  "\nMenu of the Z-matrix edit window is: \n"
  "  [Window]-[Close]\n"
  "  [Edit]-[NewAtom]\n"
  "        -[Insert]\n"
  "        -[Cut(X)]\n"
  "        -[Copy]\n"
  "        -[Paste(Y)]\n"
  "        -[ClearAll]\n"
  "        -[Pack]\n"
  "  [View]-[Apply]\n"
  "\n(III) Menu of the Label edit window is: \n"
  "  [Window]-[Close]\n"
  "  [Edit]-[NewLabel]\n"
  "        -[Insert]\n"
  "        -[Cut(X)]\n"
  "        -[Copy]\n"
  "        -[Paste(Y)]\n"
  "        -[ClearAll]\n"
  "        -[Pack]\n"
  "  [View]-[Apply]\n"
  "\n(IV) Molecular view window shows the 3D view of your \n"
  "molecule with rotation and expantion of it.  You can show \n"
  "the XYZ-axes and the grid of XY-plane togather with your \n"
  "molecule.\n";

  /**/
  XtSetArg(args[0], XmNvalue, helpmessage);
  XtSetValues(helpText, args, 1); 
  /**/
  XtManageChild(helpW);
}
