/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: filesel.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void fileselCB(Widget w, Widget win, XtPointer callData)
{
  Arg  args[10];
  Widget  fselW, helpB;

  XtSetArg(args[0], XmNfilterLabelString, XmStringCreateLocalized("Filter"));
  fselW = XmCreateFileSelectionDialog(win, "fselW", args, 1);
  helpB = XmFileSelectionBoxGetChild(fselW, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(helpB);
  XtManageChild(fselW);
  XtAddCallback(fselW, XmNcancelCallback, (XtCallbackProc)destroyWinCB, fselW);
  XtAddCallback(fselW, XmNcancelCallback, (XtCallbackProc)closeWinCB, win); 
  XtAddCallback(fselW, XmNokCallback, (XtCallbackProc)okCB, win);
  XtAddCallback(fselW, XmNokCallback, (XtCallbackProc)destroyWinCB, fselW); 

}
/*%%%%%%%%%%%%%%%%%%%%*/
void okCB(Widget w, Widget win, XmFileSelectionBoxCallbackStruct *callData)
{
  char  *s;
  Widget fnameF;

  if (win==loadW) fnameF=loadfnameF;
  else if (win==saveW) fnameF=savefnameF;
  else {printf("okCB:??\n"); exit(10);}

  XmStringGetLtoR(callData->value, XmSTRING_DEFAULT_CHARSET, &s);
  XmTextSetString(fnameF, s);

  /*printf("(okCB) File name is :%s: \n", s);*/
}
