/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: ezmatval.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void EnterZValue(Widget w, XtPointer p, XtPointer calldata)
{
  float  value;
  char *s, *endp;
  char s1[MAXLABELLENGTH+1], s2[MAXLABELLENGTH+1], s3[MAXLABELLENGTH+1];
  struct AtomData *p_atom;

  p_atom=(struct AtomData *)p;
  s=XmTextFieldGetString(w);
  strncpy(s1, s, MAXLABELLENGTH);
  if (isBlankLine(s1)) return; /**/
  sscanf(s1, "%s", s2);
  str2upper(s3, s2);
  /*printf("enterZValue:%s:\n", s3);*/
  XmTextFieldSetString(w, s3);
  if (w == p_atom->LengthID) {
    strncpy(p_atom->cLength, s3, MAXLABELLENGTH);
  } else if (w == p_atom->AngleID) {
    strncpy(p_atom->cAngle, s3, MAXLABELLENGTH);
  } else if (w == p_atom->TwistID) {
    strncpy(p_atom->cTwist, s3, MAXLABELLENGTH);
  } else {
    /*printf("WHAT ??\n");*/
    exit(6);
  }

  if (isBlankLine(s3)) return;

  /*printf("(%s)", s3);*/ /**/

  if (w == p_atom->LengthID) { /* use label ? */
    p_atom->UseLabelLength=FALSE;
  } else if (w == p_atom->AngleID) {
    p_atom->UseLabelAngle=FALSE;
  } else if (w == p_atom->TwistID) {
    p_atom->UseLabelTwist=FALSE;
  } else {
    /*printf("WHAT ??\n");*/
    exit(7);
  }
  value=(float)strtod(s3, &endp);
  /*printf("]]remainings %d<%s>; value=%g\n", strlen(endp), endp, value);*/ /**/

  if (value!=0.0 || (value==0.0 && strchr("+0.",*s3)!=NULL) ||
      (value==0.0 && '-'==(*s3) && strchr("0.",*(s3+1))!=NULL)) {
    if (!isBlankLine(endp)) {
      sprintf(s3, "%f", value);
      XmTextSetString(w, s3);
    }
    if (w == p_atom->LengthID) {
      p_atom->nLength=value;
      /*printf("bond length is %g angstrom.\n", value);*/
    } else if (w == p_atom->AngleID) {
      p_atom->nAngle=value;
      /*printf("bond angle is %g degree.\n", value);*/
    } else if (w == p_atom->TwistID) {
      p_atom->nTwist=value;
      /*printf("twist angle is %g degree.\n", value);*/
    } else {
      /*printf("WHAT ??\n");*/
      exit(8);
    }
  } else {
    /*printf("Illigal value -> suggesting to use label \n");*/
    if (w == p_atom->LengthID) {
      p_atom->UseLabelLength=TRUE;
    } else if (w == p_atom->AngleID) {
      p_atom->UseLabelAngle=TRUE;
    } else if (w == p_atom->TwistID) {
      p_atom->UseLabelTwist=TRUE;
    } else {
      /*printf("WHAT ??\n");*/
      exit(9);
    }
  }

}
