/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: ezmatatomx.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void EnterAtomX(Widget w, XtPointer p, XtPointer calldata)
{
  int n;
  char *s, *endp, s2[MAXNAMELANGTH], s1[MAXNAMELANGTH];
  Boolean  UseAtomXName=FALSE;
  struct AtomData *p_atom;

  p_atom=(struct AtomData *)p;
  s=XmTextFieldGetString(w);
  /*printf("<<%d>>%s<<", strlen(s),s);*/ /***/
  strncpy(s1, s, MAXLABELLENGTH);
  if (isBlankLine(s1)) return; /**/
  sscanf(s1, "%s", s2);
  XmTextFieldSetString(w, s2);

  n=(int)strtol(s2, &endp, 10);
  /*printf("(?)%d<%s>\n", strlen(endp),endp);*/

  if (n==0) {
    /*printf("Not an atom number: name");*/ /**/
    UseAtomXName=TRUE;
  } else if (n<0) {
    /*printf("Not an atom number: Ignored");*/ /**/
    strcpy(s2, " ");
    XmTextSetString(w, s2);
  } else {
    if (!isBlankLine(endp)) {
      sprintf(s2, "%d", n);
      XmTextSetString(w, s2);
    }
    if (w == p_atom->Atom1ID) {
      p_atom->nAtom1=n;
      strncpy(p_atom->cAtom1, s2, MAXLABELLENGTH);
    } else if (w == p_atom->Atom2ID) {
      p_atom->nAtom2=n;
      strncpy(p_atom->cAtom2, s2, MAXLABELLENGTH);
    } else if (w == p_atom->Atom3ID) {
      p_atom->nAtom3=n;
      strncpy(p_atom->cAtom3, s2, MAXLABELLENGTH);
    } else {
      /*printf("WHAT ??\n");*/
      exit(5);
    }
/*printf("Atom-(%s) is connect to Atom-%s.\n", p_atom->Name, XmTextFieldGetString(w))*/; /**/
  }

}
