/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: elabelval.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

void EnterValue(Widget w, XtPointer p, XtPointer calldata)
{
  float v;
  char *s, *endp, s2[MAXNAMELANGTH+1];
  struct LabelData *p_label;

  p_label=(struct LabelData *)p;
  s=XmTextFieldGetString(w);
  sscanf(s, "%s", s2);
  if (strchr("+-.",*s2)==NULL && isalnum(*s2)==0) {
    strcpy(s2, " "); 
  }
  strncpy(p_label->cValue, s2, MAXNAMELANGTH);
  XmTextFieldSetString(w, s2);
  if (isBlankLine(s2)) return; /**/

  /*printf("(%s) ", s2);*/
  v=(float)strtod(s2, &endp);
  /*printf(">>remainings %d[%s]; value=%g\n", strlen(endp), endp, v);*/ /**/
  if (v!=0.0 || (v==0.0 && strchr("+0.",*s2)!=NULL) ||
      (v==0.0 && '-'==(*s2) && strchr("0.",*(s2+1))!=NULL)) {
    if (!isBlankLine(endp)) {
      sprintf(s2, "%g", v);
      XmTextSetString(w, s2);
    }
    p_label->nValue=v;
    /*printf("label value is (%g)\n", v);*/
  } else {
    /*printf("Illigal value\n");*/
  }

}
