/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: drawmol.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

Boolean drawMol(Widget w)
{
  int n, m, k, i;
  int x1, y1, x2, y2;
  int zbuf[MAXATOM];
  float zmax;
  float x[3], xnew[3], r, distance, bonding;
  unsigned int radii;
  int a1=0*64, a2=360*64;
  XColor c0, c1;
  Widget da;

  if (CannotDraw) return TRUE;
  if (!XtIsManaged(viewW)) return TRUE;

  da=viewwindrawarea;
  cmap=DefaultColormap(XtDisplay(da), 0);
  gc = XCreateGC(XtDisplay(da), XtWindow(da), 0, NULL);

  for(n=1; n<Natom; n++) {
    x[0]=atom[n].x2; x[1]=atom[n].y2; x[2]=atom[n].z2;
    trans3dto2d(x, xnew);
    r=factor*element[atom[n].AtomNo].VdwRadii/10;
    x[0]=xnew[0]-r; x[1]=xnew[1]+r; 
    getDisplayCoordinates(x, xnew);
    atom[n].displayX=xnew[0];
    atom[n].displayY=xnew[1];
    atom[n].displayZ=xnew[2];
    atom[n].displayR=r*DAWIDTH/(region*2.4)+0.5;
  }

/*printf("Natom=%d\n", Natom);*/
  for(n=1; n<Natom; n++) zbuf[n]=n;
  for(n=1; n<Natom-1; n++) {
    zmax=atom[zbuf[n]].displayZ; k=n;
    for(m=n+1; m<Natom; m++) 
      if (atom[zbuf[m]].displayZ > zmax) {zmax=atom[zbuf[m]].displayZ; k=m;}
    m=zbuf[n]; zbuf[n]=zbuf[k]; zbuf[k]=m;
/*for(i=1; i<Natom; i++) printf(" %d %g", zbuf[i], atom[zbuf[i]].displayZ);
puts("\n");*/
  }

  XClearWindow(XtDisplay(da), XtWindow(da));

  if (showGrid) drawGrid(da);
  if (showAxes) drawAxes(da);
  if (isTrackBallOn) drawTrackBall(da);

  for(n=1; n<Natom; n++) {
    /* drawing atoms and bonds */
/*printf("drawMol:%d:(x2,y2,z2)=(%g,%g,%g)(%g,%g,%g)\n", n,atom[n].x2,atom[n].y2,atom[n].z2,atom[n].displayX,atom[n].displayY,atom[n].displayZ);*/
    radii=(unsigned int)atom[zbuf[n]].displayR;
    XAllocNamedColor(XtDisplay(da), cmap, element[atom[zbuf[n]].AtomNo].ColorName, &c0, &c1);
    XSetForeground(XtDisplay(da), gc, c0.pixel);
    XFillArc(XtDisplay(da), XtWindow(da), gc, atom[zbuf[n]].displayX, atom[zbuf[n]].displayY, radii*2, radii*2, a1, a2); 
    if (showNumbering) drawNumbering(da, atom[zbuf[n]].displayX, atom[zbuf[n]].displayY, atom[zbuf[n]].AtomOrder);
    for(m=n+1; m<Natom; m++) {
      distance=sqrt((atom[zbuf[n]].x-atom[zbuf[m]].x)*(atom[zbuf[n]].x-atom[zbuf[m]].x)
         +(atom[zbuf[n]].y-atom[zbuf[m]].y)*(atom[zbuf[n]].y-atom[zbuf[m]].y)
         +(atom[zbuf[n]].z-atom[zbuf[m]].z)*(atom[zbuf[n]].z-atom[zbuf[m]].z));
      bonding=0.6*(element[atom[zbuf[n]].AtomNo].VdwRadii+element[atom[zbuf[m]].AtomNo].VdwRadii);
/*printf("d=%g, r1(%s)=%g, r2(%s)=%g\n", distance, element[atom[zbuf[n]].AtomNo].Name, element[atom[zbuf[n]].AtomNo].VdwRadii, element[atom[zbuf[m]].AtomNo].Name, element[atom[zbuf[m]].AtomNo].VdwRadii);*/
      if (distance<=bonding) {
	x1=atom[zbuf[n]].displayX+atom[zbuf[n]].displayR;
	y1=atom[zbuf[n]].displayY+atom[zbuf[n]].displayR;
	x2=atom[zbuf[m]].displayX+atom[zbuf[m]].displayR;
	y2=atom[zbuf[m]].displayY+atom[zbuf[m]].displayR;
	XAllocNamedColor(XtDisplay(da), cmap, "Black", &c0, &c1);
	XSetForeground(XtDisplay(da), gc, c0.pixel);
	XSetLineAttributes(XtDisplay(da), gc, 2, LineSolid, CapRound, JoinRound);
	XDrawLine(XtDisplay(da), XtWindow(da), gc, x1, y1, x2, y2);
      }
    }
  }

  return TRUE;
}
/*%%%%%%%%%%%%%%%%%%%%*/
/*
  3d cartesian coordinate (x,y,z) to 2d screen (X,Y,Z)
      X = x*d/(h-z)
      Y = y*d/(h-z)
      Z = (h-z)-d

  you are staying on (0,0,h) and looking to -z direction
  viewpoint, h = VIEWPOS \AA
  screen distance, d = SCDIST \AA 
*/
void trans3dto2d(float xyz[3], float newxyz[3])
{
  float h=VIEWPOS, d=SCDIST;

  newxyz[0] = factor*xyz[0]*d/(h-xyz[2]);
  newxyz[1] = factor*xyz[1]*d/(h-xyz[2]);
  newxyz[2] = (h-xyz[2])-d;
}
/*%%%%%%%%%%%%%%%%%%%%*/
void getDisplayCoordinates(float x[2], float y[2])
{
  y[0]=x[0]*DAWIDTH/(region*2.4)+DAWIDTH/2.0;
  y[1]=-x[1]*DAWIDTH/(region*2.4)+DAWIDTH/2.0;
}
/*%%%%%%%%%%%%%%%%%%%%*/

