/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: drawaxes.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

char dottedLine[]={1, 9};

void drawAxes(Widget w)
{
  int x1, y1, x2, y2;
  float x[3], xnew[3];
  XColor c0, c1;

  /***** Show XYZ-axes *****/
  XAllocNamedColor(XtDisplay(w), cmap, "Black", &c0, &c1);
  XSetLineAttributes(XtDisplay(viewwindrawarea), gc, 1, LineOnOffDash, CapRound, JoinRound);

  x[0]=-AXIS*RR[0][0]; x[1]=-AXIS*RR[1][0]; x[2]=-AXIS*RR[2][0]; /* x-axis */
  trans3dto2d(x, xnew);
  x[0]=xnew[0]; x[1]=xnew[1]; getDisplayCoordinates(x, xnew);
  x1=xnew[0]; y1=xnew[1];
  x[0]=+AXIS*RR[0][0]; x[1]=+AXIS*RR[1][0]; x[2]=+AXIS*RR[2][0]; 
  trans3dto2d(x, xnew);
  x[0]=xnew[0]; x[1]=xnew[1]; getDisplayCoordinates(x, xnew);
  x2=xnew[0]; y2=xnew[1];
  XDrawLine(XtDisplay(viewwindrawarea), XtWindow(viewwindrawarea), gc, x1, y1, x2, y2);

  x[0]=-AXIS*RR[0][1]; x[1]=-AXIS*RR[1][1]; x[2]=-AXIS*RR[2][1]; /* y-axis */
  trans3dto2d(x, xnew);
  x[0]=xnew[0]; x[1]=xnew[1]; getDisplayCoordinates(x, xnew);
  x1=xnew[0]; y1=xnew[1];
  x[0]=+AXIS*RR[0][1]; x[1]=+AXIS*RR[1][1]; x[2]=+AXIS*RR[2][1];
  trans3dto2d(x, xnew);
  x[0]=xnew[0]; x[1]=xnew[1]; getDisplayCoordinates(x, xnew);
  x2=xnew[0]; y2=xnew[1];
  XDrawLine(XtDisplay(viewwindrawarea), XtWindow(viewwindrawarea), gc, x1, y1, x2, y2);

  x[0]=-AXIS*RR[0][2]; x[1]=-AXIS*RR[1][2]; x[2]=-AXIS*RR[2][2]; /* z-axis */
  trans3dto2d(x, xnew);
  x[0]=xnew[0]; x[1]=xnew[1]; getDisplayCoordinates(x, xnew);
  x1=xnew[0]; y1=xnew[1];
  x[0]=+AXIS*RR[0][2]; x[1]=+AXIS*RR[1][2]; x[2]=+AXIS*RR[2][2];
  trans3dto2d(x, xnew);
  x[0]=xnew[0]; x[1]=xnew[1]; getDisplayCoordinates(x, xnew);
  x2=xnew[0]; y2=xnew[1];
  XDrawLine(XtDisplay(viewwindrawarea), XtWindow(viewwindrawarea), gc, x1, y1, x2, y2);

}
/******************************/
void drawGrid(Widget w)
{
  int i;
  int x1, y1, x2, y2;
  float x[3], xnew[3];
  XColor c0, c1;

  /***** Show XY-plane as Grid *****/
  XAllocNamedColor(XtDisplay(w), cmap, "Black", &c0, &c1);
  XSetLineAttributes(XtDisplay(viewwindrawarea), gc, 1, LineOnOffDash, CapRound, JoinRound);

  for (i=-GRID; i<=GRID; i+=1) {  /* line // x-axis */
    x[0]=-GRID*RR[0][0]+i*RR[0][1]; x[1]=-GRID*RR[1][0]+i*RR[1][1]; x[2]=-GRID*RR[2][0]+i*RR[2][1];
    trans3dto2d(x, xnew);
    x[0]=xnew[0]; x[1]=xnew[1]; getDisplayCoordinates(x, xnew);
    x1=xnew[0]; y1=xnew[1];
    x[0]=+GRID*RR[0][0]+i*RR[0][1]; x[1]=+GRID*RR[1][0]+i*RR[1][1]; x[2]=+GRID*RR[2][0]+i*RR[2][1]; 
    trans3dto2d(x, xnew);
    x[0]=xnew[0]; x[1]=xnew[1]; getDisplayCoordinates(x, xnew);
    x2=xnew[0]; y2=xnew[1];
    XSetDashes(XtDisplay(viewwindrawarea), gc, 0, dottedLine, 2);
    XDrawLine(XtDisplay(viewwindrawarea), XtWindow(viewwindrawarea), gc, x1, y1, x2, y2);
  }

  for (i=-GRID; i<=GRID; i+=1) {  /* line // y-axis */
    x[0]=+i*RR[0][0]-GRID*RR[0][1]; x[1]=+i*RR[1][0]-GRID*RR[1][1]; x[2]=+i*RR[2][0]-GRID*RR[2][1];
    trans3dto2d(x, xnew);
    x[0]=xnew[0]; x[1]=xnew[1]; getDisplayCoordinates(x, xnew);
    x1=xnew[0]; y1=xnew[1];
    x[0]=+i*RR[0][0]+GRID*RR[0][1]; x[1]=+i*RR[1][0]+GRID*RR[1][1]; x[2]=+i*RR[2][0]+GRID*RR[2][1]; 
    trans3dto2d(x, xnew);
    x[0]=xnew[0]; x[1]=xnew[1]; getDisplayCoordinates(x, xnew);
    x2=xnew[0]; y2=xnew[1];
    XSetDashes(XtDisplay(viewwindrawarea), gc, 0, dottedLine, 2);
    XDrawLine(XtDisplay(viewwindrawarea), XtWindow(viewwindrawarea), gc, x1, y1, x2, y2);
  }

}
/******************************/
void drawNumbering(Widget da, float displayX, float displayY, int AtomOrder)
{
  XFontStruct *fontset;
  /*XmFontListEntry flentry;*/
  XmFontList fontlist;
  XmString xms;
  XColor fg, bg, c;
  int width;
  char number[5];
  char *fontname="-*-helvetica-bold-r-normal-*-20-*-*-*-*-*-iso8859-1";

  fontset=XLoadQueryFont(XtDisplay(da), fontname);
  fontlist=XmFontListCreate(fontset, "atomlabel");
  /*flentry=XmFontListEntryLoad(XtDisplay(da), fontname, XmFONT_IS_FONTSET, XmFONTLIST_DEFAULT_TAG);
  fontlist=XmFontListAppendEntry(NULL, flentry);*/

  sprintf(number, "%d", AtomOrder);
  xms=XmStringCreateLtoR(number, "atomlabel");
  width=XmStringWidth(fontlist, xms);

  XAllocNamedColor(XtDisplay(da), cmap, "Black", &fg, &c);
  XSetForeground(XtDisplay(da), gc, fg.pixel);
  /*XAllocNamedColor(XtDisplay(da), cmap, "White", &bg, &c);
  XSetBackground(XtDisplay(da), gc, bg.pixel);*/

  XSetFont(XtDisplay(da), gc, fontset->fid);

  XmStringDraw(XtDisplay(da), XtWindow(da), fontlist, xms, gc, displayX, displayY, width, XmALIGNMENT_CENTER, XmSTRING_DIRECTION_L_TO_R, NULL);
  /*XmStringDrawImage(XtDisplay(da), XtWindow(da), fontlist, xms, gc, displayX, displayY, width, XmALIGNMENT_CENTER, XmSTRING_DIRECTION_L_TO_R, NULL);*/
}
/******************************/
void drawTrackBall(Widget w)
{
  int a1=0*64, a2=360*64;
  XColor c0, c1;

  XAllocNamedColor(XtDisplay(w), cmap, "Black", &c0, &c1);
  XSetLineAttributes(XtDisplay(viewwindrawarea), gc, 1, LineSolid, CapRound, JoinRound);
  XSetForeground(XtDisplay(w), gc, c0.pixel);
  XDrawArc(XtDisplay(w), XtWindow(w), gc, DAWIDTH*0.1, DAWIDTH*0.1, DAWIDTH*0.8, DAWIDTH*0.8, a1, a2); 

}
