#!/bin/sh
#
# $Id: config.sh,v 1.3 2001/01/16 13:55:33 rmiya Exp $
#

OS=`uname`

rm -f Makefile

if [ "X${OS}" = X"FreeBSD" ]; then
# FreeBSD
  cat > Makefile <<EOF
  CFLAGS = -O2 -I/usr/X11R6/include -Wall
  LFLAGS = -L/usr/X11R6/lib -lXm -lXext -lXt -lX11 -lSM -lICE -lm
  TARGET = kumi #kumi-s
  TARGETNAME = kumi
EOF
elif [ "X${OS}" = X"Linux" ]; then
# RedHat Linux + openmotif-2.1.30-2_ICS
  cat > Makefile <<EOF
  CFLAGS = -O2 -I/usr/X11R6/include -Wall
  LFLAGS = -L/usr/X11R6/lib -lXp -lXm -lXext -lXt -lX11 -lm
  TARGET = kumi
  TARGETNAME = kumi
EOF
elif [ "X${OS}" = X"IRIX" ]; then
# Contec 4D
  cat > Makefile <<EOF
  CFLAGS = -O2 -Wall
  LFLAGS = -lXm -lXt -lX11 -lm
  TARGET = kumi
  TARGETNAME = \${TARGET} #.${OS}
EOF
elif [ "X${OS}" = X"UNIX_SV" ]; then
# NEC UP/EWS4800
  cat > Makefile <<EOF
  CFLAGS = -O2 -Wall
  LFLAGS = -L/usr/abiccs/lib -lXm -lXt -lX11 -lsocket -lgen -lnsl -lm
###  -L/usr/lib or -L/usr/abiccs/lib or  -L/usr/necccs/lib
  TARGET = kumi
  TARGETNAME = \${TARGET} #.${OS}
EOF
fi

cat < Makefile.input >> Makefile

make clean
