/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: cklbldef.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

int CheckLabelDefinition(Widget w)
{
  int  i, j, match=0;
  char labels[BUFFLEN], s[BUFFLEN];
  Boolean  LabelUndef, TooManyUndef;

  LabelUndef=FALSE; TooManyUndef=FALSE;
  sprintf(labels, "Undefined Label(s):\n");
/* assign labels */
/* Does labeles are defined ? */
  for (i=1; i<Natom; i++) {
    if (i==1) continue;
    if (atom[i].UseLabelLength) {
      j=1;
      while(j<Nlabel && (match=strcmp(atom[i].cLength, label[j].Tag))!=0
	    && (*(atom[i].cLength)!='-' || (match=strcmp((atom[i].cLength+1), label[j].Tag))!=0)) {
	j++;
      }
      if (match==0 && *(atom[i].cLength)!='-') {
	atom[i].nLength=label[j].nValue;
	/*printf("(%d %d)label match: %s = %g\n", i, j, atom[i].cLength, atom[i].nLength);*/
      } else if (match==0 && *(atom[i].cLength)=='-') {
	atom[i].nLength=(-1)*label[j].nValue;
	/*printf("(%d %d)label match: %s = %g\n", i, j, atom[i].cLength, atom[i].nLength);*/
      } else if (match!=0) {
	/*printf("(%d %d)label: %s: not defined\n", i, j, atom[i].cLength);*/
	LabelUndef=TRUE;
	sprintf(s, " %s\n", atom[i].cLength);
	strcat(labels, s);
	if (strlen(labels)>(BUFFLEN-MAXLABELLENGTH*2)) {
	  TooManyUndef=TRUE;
	  break;
	}
      }
    }
    if (i==2) continue;
    if (atom[i].UseLabelAngle) {
      j=1;
      while(j<Nlabel && (match=strcmp(atom[i].cAngle, label[j].Tag))!=0
	    && (*(atom[i].cAngle)!='-' || (match=strcmp((atom[i].cAngle+1), label[j].Tag))!=0)) {
	j++;
      }
      if (match==0 && *(atom[i].cAngle)!='-') {
	atom[i].nAngle=label[j].nValue;
	/*printf("(%d %d)label match: %s = %g\n", i, j, atom[i].cAngle, atom[i].nAngle);*/
      } else if (match==0 && *(atom[i].cAngle)=='-') {
	atom[i].nAngle=(-1)*label[j].nValue;
	/*printf("(%d %d)label match: %s = %g\n", i, j, atom[i].cAngle, atom[i].nAngle);*/
      } else if (match!=0) {
	/*printf("(%d %d)label: %s: not defined\n", i, j, atom[i].cAngle);*/
	LabelUndef=TRUE;
	sprintf(s, " %s\n", atom[i].cAngle);
	strcat(labels, s);
	if (strlen(labels)>(BUFFLEN-MAXLABELLENGTH*2)) {
	  TooManyUndef=TRUE;
	  break;
	}
      }
    }
    if (i==3) continue;
    if (atom[i].UseLabelTwist) {
      j=1;
      while(j<Nlabel && (match=strcmp(atom[i].cTwist, label[j].Tag))!=0
	    && (*(atom[i].cTwist)!='-' || (match=strcmp((atom[i].cTwist+1), label[j].Tag))!=0)) {
	j++;
      }
      if (match==0 && *(atom[i].cTwist)!='-') {
	atom[i].nTwist=label[j].nValue;
	/*printf("(%d %d)label match: %s = %g\n", i, j, atom[i].cTwist, atom[i].nTwist);*/
      } else if (match==0 && *(atom[i].cTwist)=='-') {
	atom[i].nTwist=(-1)*label[j].nValue;
	/*printf("(%d %d)label match: %s = %g\n", i, j, atom[i].cTwist, atom[i].nTwist);*/
      } else if (match!=0) {
	/*printf("(%d %d)label: %s: not defined\n", i, j, atom[i].cTwist);*/
	LabelUndef=TRUE;
	sprintf(s, " %s\n", atom[i].cTwist);
	strcat(labels, s);
	if (strlen(labels)>(BUFFLEN-MAXLABELLENGTH*2)) {
	  TooManyUndef=TRUE;
	  break;
	}
      }
    }
  }

  if (TooManyUndef) {
    sprintf(s, "... \n Too Many Undefined Labels\n");
    strcat(labels, s);
  }
  if (LabelUndef) {
    Caution(w, labels);
    return(0);
  } else {
    return(1);
  }

}
