/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: ckblkfm.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

int CheckBlankForm(Widget w)
{
  int  i;
  char blankBox[BUFFLEN], s[BUFFLEN];
  Boolean  Blank, TooManyBlank;

  Blank=FALSE; TooManyBlank=FALSE;
  strcat(blankBox, "Blank Box(es):\n");
/* blank boxes */
  for (i=1; i<Natom; i++) {
    if (isBlankLine(atom[i].Name)) {
      Blank=TRUE;
      sprintf(s, " Atom-(%d): No Name\n", atom[i].AtomOrder);
      strcat(blankBox, s);
      if (strlen(blankBox)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyBlank=TRUE;
	break;
      }
    }
    if (i==1) continue;
    if (isBlankLine(atom[i].cAtom1)) {
      Blank=TRUE;
      sprintf(s, " Atom-(%d, %s): No Conn.r Atom\n", atom[i].AtomOrder, atom[i].Name);
      strcat(blankBox, s);
      if (strlen(blankBox)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyBlank=TRUE;
	break;
      }
    }
    if (isBlankLine(atom[i].cLength)) {
      Blank=TRUE;
      sprintf(s, " Atom-(%d, %s): No Length\n", atom[i].AtomOrder, atom[i].Name);
      strcat(blankBox, s);
      if (strlen(blankBox)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyBlank=TRUE;
	break;
      }
    }
    if (i==2) continue;
    if (isBlankLine(atom[i].cAtom2)) {
      Blank=TRUE;
      sprintf(s, " Atom-(%d, %s): No Conn.a Atom\n", atom[i].AtomOrder, atom[i].Name);
      strcat(blankBox, s);
      if (strlen(blankBox)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyBlank=TRUE;
	break;
      }
    }
    if (isBlankLine(atom[i].cAngle)) {
      Blank=TRUE;
      sprintf(s, " Atom-(%d, %s): No Angle\n", atom[i].AtomOrder, atom[i].Name);
      strcat(blankBox, s);
      if (strlen(blankBox)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyBlank=TRUE;
	break;
      }
    }
    if (i==3) continue;
    if (isBlankLine(atom[i].cAtom3)) {
      Blank=TRUE;
      sprintf(s, " Atom-(%d, %s): No Conn.d Atom\n", atom[i].AtomOrder, atom[i].Name);
      strcat(blankBox, s);
      if (strlen(blankBox)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyBlank=TRUE;
	break;
      }
    }
    if (isBlankLine(atom[i].cTwist)) {
      Blank=TRUE;
      sprintf(s, " Atom-(%d, %s): No Twist\n", atom[i].AtomOrder, atom[i].Name);
      strcat(blankBox, s);
      if (strlen(blankBox)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyBlank=TRUE;
	break;
      }
    }
  }

  if (TooManyBlank) {
    sprintf(s, "... \n Too Many Blank Boxes\n");
    strcat(blankBox, s);
  }
  if (Blank) {
    Caution(w, blankBox);
    return(0);
  } else {
    return(1);
  }

}
