/********************
 **
 **  Z-matrix Editor ``KUMI''
 **
 **  copyright by Ryo MIYAMOTO, 1997-2001
 **
 ** $Id: ckatoms.c,v 1.1.1.1 2001/01/15 07:43:48 rmiya Exp $ 
 **
 ********************/

#include "kumi02.h"

int CheckAtoms(Widget w)
{
  int  i;
  char atomsConn[BUFFLEN], s[BUFFLEN];
  Boolean  AtomConnectError, TooManyUndef;

  AtomConnectError=FALSE; TooManyUndef=FALSE;
  strcat(atomsConn, "Connection ERROR on Atom(s):\n");
/* atom no. (atom1, atom2, atom3) are smaller than atom0 itself */
  for (i=1; i<Natom; i++) {
    if (i==1) continue;
    if (i <= atom[i].nAtom1) {
      AtomConnectError=TRUE;
      sprintf(s, " (%d, %s) in connection to (%s)\n", i, atom[i].Name, atom[i].cAtom1);
      strcat(atomsConn, s);
      if (strlen(atomsConn)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyUndef=TRUE;
	break;
      }
    }
    if (i==2) continue;
    if (i <= atom[i].nAtom2) {
      AtomConnectError=TRUE;
      sprintf(s, " (%d, %s) in angle to (%s)\n", i, atom[i].Name, atom[i].cAtom2);
      strcat(atomsConn, s);
      if (strlen(atomsConn)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyUndef=TRUE;
	break;
      }
    } else if (atom[i].nAtom1 == atom[i].nAtom2) {
      AtomConnectError=TRUE;
      sprintf(s, " (%d, %s) in angle same atom to (%s)\n", i, atom[i].Name, atom[i].cAtom2);
      strcat(atomsConn, s);
      if (strlen(atomsConn)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyUndef=TRUE;
	break;
      }
    }
    if (i==3) continue;
    if (i <= atom[i].nAtom3) {
      AtomConnectError=TRUE;
      sprintf(s, " (%d, %s) in twist to (%s)\n", i, atom[i].Name, atom[i].cAtom3);
      strcat(atomsConn, s);
      if (strlen(atomsConn)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyUndef=TRUE;
	break;
      }
    } else if (atom[i].nAtom3 == atom[i].nAtom1 || atom[i].nAtom3 == atom[i].nAtom2) {
      AtomConnectError=TRUE;
      sprintf(s, " (%d, %s) in twist same atom to (%s)\n", i, atom[i].Name, atom[i].cAtom3);
      strcat(atomsConn, s);
      if (strlen(atomsConn)>(BUFFLEN-MAXLABELLENGTH*2)) {
	TooManyUndef=TRUE;
	break;
      }
    }

  }

  if (TooManyUndef) {
    sprintf(s, "... \n Too Many Connection Errors\n");
    strcat(atomsConn, s);
  }
  if (AtomConnectError) {
    Caution(w, atomsConn);
    return(0);
  } else {
    return(1);
  }

}
